/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.qiho.center.api.params.WdtOrderAuditParams;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WdtOrderAuditHandler
implements AbstractOrderHandler<WdtOrderAuditParams> {
    @Autowired
    private RemoteErpOrderService remoteErpOrderService;
    private Logger logger = LoggerFactory.getLogger(WdtOrderAuditHandler.class);
    private Splitter splitter = Splitter.on((String)",").trimResults().limit(3);

    @Override
    public WdtOrderAuditParams transform(String row, String status) {
        WdtOrderAuditParams params = new WdtOrderAuditParams();
        try {
            List line = this.splitter.splitToList((CharSequence)row);
            if (line.size() < 3) {
                return new WdtOrderAuditParams();
            }
            params.setErpId((String)line.get(0));
            params.setLogisticsName((String)line.get(1));
            params.setPostId((String)line.get(2));
            return params;
        }
        catch (Exception e) {
            this.logger.info("\u65fa\u5e97\u901a\u8ba2\u5355\u884c\u89e3\u6790\u5931\u8d25={}", (Object)e, (Object)row);
            return null;
        }
    }

    @Override
    public WdtOrderAuditParams transform(String row) {
        return this.transform(row, null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<WdtOrderAuditParams> list) {
        return this.exeTask(cacheKey, list, (JSONObject)null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<WdtOrderAuditParams> list, JSONObject extraParams) {
        DubboResult result = this.remoteErpOrderService.wdtBatchAuditOrder(cacheKey, list);
        return (Integer)result.getResult();
    }
}

