/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.advert.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.advert.CollectionAdvertDto;
import com.qiho.center.api.remoteservice.advert.RemoteCollectionAdvertService;
import com.qiho.center.api.remoteservice.page.RemoteCollPageBackendService;
import com.qiho.manager.biz.params.advert.CollectionAdvertSaveParam;
import com.qiho.manager.biz.service.advert.CollectionAdvertService;
import com.qiho.manager.biz.vo.advert.CollectionAdvertVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CollectionAdvertServiceImpl
implements CollectionAdvertService {
    @Autowired
    private RemoteCollectionAdvertService remoteCollectionAdvertService;
    @Autowired
    private RemoteCollPageBackendService remoteCollPageBackendService;

    @Override
    public Boolean saveCollectionAdvert(CollectionAdvertSaveParam param) {
        AssertUtil.numericIsPositive((Long)param.getCollectionId(), (String)"\u96c6\u5408\u9875id\u4e0d\u5408\u6cd5");
        AssertUtil.collectionOnRange(param.getAdvertIds(), (int)1, (int)5, (String)"\u5e7f\u544a\u4f4did\u9650\u5b9a\u57281-5\u4e2a");
        this.checkRepeat(param);
        if (param.getId() == null) {
            return this.createCollectionAdvert(param);
        }
        return this.updateCollectionAdvert(param);
    }

    private void checkRepeat(CollectionAdvertSaveParam param) {
        List<Long> advertIdList = param.getAdvertIds();
        HashSet<Long> advertIdSet = new HashSet<Long>(advertIdList);
        if (advertIdList.size() == advertIdSet.size()) {
            return;
        }
        advertIdList = advertIdList.stream().collect(Collectors.toMap(e -> e, e -> 1, (a, b) -> a + b)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> (Long)entry.getKey()).collect(Collectors.toList());
        throw new QihoManagerException("\u5e7f\u544a\u4f4did=" + advertIdList.toString() + "\u5b58\u5728\u91cd\u590d");
    }

    @Override
    public List<CollectionAdvertVO> listAllCollectionAdvert() {
        List list = this.remoteCollectionAdvertService.listAllCollectionAdvert();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        ArrayList<CollectionAdvertVO> voList = new ArrayList<CollectionAdvertVO>();
        Joiner joiner = Joiner.on((String)" ");
        for (CollectionAdvertDto e : list) {
            CollectionAdvertVO vo = (CollectionAdvertVO)BeanUtils.copy((Object)e, CollectionAdvertVO.class);
            vo.setAdvertIdString(joiner.join((Iterable)e.getAdvertIds()));
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public Boolean delete(Long id) {
        AssertUtil.numericIsPositive((Long)id, (String)"id\u4e0d\u5408\u6cd5");
        CollectionAdvertDto collectionAdvert = new CollectionAdvertDto();
        collectionAdvert.setId(id);
        collectionAdvert.setOpeartor(RequestTool.getAdmin().getName());
        ResultDto result = this.remoteCollectionAdvertService.deletedCollectionAdvert(collectionAdvert);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        return (Boolean)result.getResult();
    }

    @Override
    public CollectionAdvertVO findById(Long id) {
        if (id == null || id < 1L) {
            return null;
        }
        return (CollectionAdvertVO)BeanUtils.copy((Object)this.remoteCollectionAdvertService.findById(id), CollectionAdvertVO.class);
    }

    private Boolean createCollectionAdvert(CollectionAdvertSaveParam param) {
        if (this.remoteCollPageBackendService.findById(param.getCollectionId()) == null) {
            throw new QihoManagerException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u96c6\u5408\u9875ID");
        }
        if (this.remoteCollectionAdvertService.findByCollectionId(param.getCollectionId()) != null) {
            throw new QihoManagerException("\u8be5\u96c6\u5408\u9875ID\u5df2\u5b58\u5728");
        }
        CollectionAdvertDto collectionAdvert = new CollectionAdvertDto();
        collectionAdvert.setCollectionId(param.getCollectionId());
        collectionAdvert.setAdvertIds(param.getAdvertIds());
        collectionAdvert.setOpeartor(RequestTool.getAdmin().getName());
        ResultDto result = this.remoteCollectionAdvertService.insertCollectionAdvert(collectionAdvert);
        if (!result.isSuccess()) {
            throw new QihoManagerException(StringUtils.defaultString((String)result.getMsg()));
        }
        return (Boolean)result.getResult();
    }

    private Boolean updateCollectionAdvert(CollectionAdvertSaveParam param) {
        AssertUtil.numericIsPositive((Long)param.getId(), (String)"\u96c6\u5408\u9875id\u4e0d\u5408\u6cd5");
        CollectionAdvertDto collectionAdvert = new CollectionAdvertDto();
        collectionAdvert.setId(param.getId());
        collectionAdvert.setCollectionId(param.getCollectionId());
        collectionAdvert.setAdvertIds(param.getAdvertIds());
        collectionAdvert.setOpeartor(RequestTool.getAdmin().getName());
        ResultDto result = this.remoteCollectionAdvertService.updateCollectionAdvert(collectionAdvert);
        if (!result.isSuccess()) {
            throw new QihoManagerException(StringUtils.defaultString((String)result.getMsg()));
        }
        return (Boolean)result.getResult();
    }
}

