/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.agent.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.agent.BaiqiAgentSaveDto;
import com.qiho.center.api.params.agent.AgentPageParam;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentBackendService;
import com.qiho.manager.biz.params.agent.AgentSaveParam;
import com.qiho.manager.biz.service.agent.BaiqiAgentService;
import com.qiho.manager.biz.vo.AgentSimpleVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.agent.AgentVO;
import com.qiho.manager.biz.vo.merchant.SimpleMerchantVO;
import com.qiho.manager.biz.vo.merchant.SpecialSimpleVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="baiqiAgentService")
public class BaiqiAgentServiceImpl
implements BaiqiAgentService {
    @Resource
    private RemoteBaiqiAgentBackendService remoteBaiqiAgentBackendService;
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    @Override
    public Pagenation<AgentVO> pageQuery(AgentPageParam params) {
        Boolean seeAllAgent = this.adminPowerCacheService.hasPower(RequestTool.getAdminId(), "seeAllAgent");
        if (!seeAllAgent.booleanValue()) {
            params.setOwnerAeName(RequestTool.getAdmin().getName());
        }
        Pagenation<AgentVO> page = new Pagenation<AgentVO>();
        PagenationDto result = this.remoteBaiqiAgentBackendService.find4Page(params);
        page.setTotal(result.getTotal());
        if (result.getTotal() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        page.setList(BeanUtils.copyList((List)result.getList(), AgentVO.class));
        return page;
    }

    @Override
    public Boolean save(AgentSaveParam agentSaveParam) {
        BaiqiAgentSaveDto saveDto = new BaiqiAgentSaveDto();
        saveDto.setAgentName(agentSaveParam.getAgentName().trim());
        saveDto.setContactMobile(agentSaveParam.getContactMobile().trim());
        saveDto.setContactName(agentSaveParam.getContactName().trim());
        saveDto.setId(agentSaveParam.getId());
        saveDto.setOperator(RequestTool.getAdmin().getEmail());
        saveDto.setOwnerAe(RequestTool.getAdmin().getName());
        if (StringUtil.isNotEmpty((String)agentSaveParam.getMerchantIds())) {
            saveDto.setMerchantIds(StringUtil.stringToListOrderByIds((String)agentSaveParam.getMerchantIds()));
        }
        try {
            return this.remoteBaiqiAgentBackendService.save(saveDto);
        }
        catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
    }

    @Override
    public List<SimpleMerchantVO> findMerchant() {
        return BeanUtils.copyList((List)this.remoteBaiqiAgentBackendService.findAllIdAndNames(), SimpleMerchantVO.class);
    }

    @Override
    public List<SimpleMerchantVO> findMerchantByAgentId(Long agentId) {
        return BeanUtils.copyList((List)this.remoteBaiqiAgentBackendService.findMerchantsByAgentId(agentId), SimpleMerchantVO.class);
    }

    @Override
    public List<SpecialSimpleVO> findAll() {
        List list = this.remoteBaiqiAgentBackendService.findAll();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        ArrayList<SpecialSimpleVO> vos = new ArrayList<SpecialSimpleVO>();
        for (BaiqiAgentDto dto : list) {
            SpecialSimpleVO vo = new SpecialSimpleVO();
            vo.setId(dto.getId());
            vo.setName(dto.getAgentName());
            vo.setContactName(dto.getContactName());
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<AgentSimpleVO> findNoOpenInterface(String agentName) {
        List agentDtos = this.remoteBaiqiAgentBackendService.findNoOpenInterface(agentName);
        return BeanUtils.copyList((List)agentDtos, AgentSimpleVO.class);
    }
}

