/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.bizlog.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.bizlog.QihoBizlogDto;
import com.qiho.center.api.enums.bizlog.BizLogStatusEnum;
import com.qiho.center.api.enums.bizlog.BizLogTypeEnum;
import com.qiho.center.api.params.bizlog.QihoBizlogParams;
import com.qiho.center.api.remoteservice.bizlog.RemoteBizlogBackendService;
import com.qiho.manager.biz.service.bizlog.QihoBizlogService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.bizlog.QihoBizlogVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="qihoBizlogService")
public class QihoBizlogServiceImpl
implements QihoBizlogService {
    @Resource
    private RemoteBizlogBackendService remoteBizlogBackendService;

    @Override
    public Pagenation<QihoBizlogVO> findPage(int offset, int pageSize) {
        QihoBizlogParams bizlogParams = new QihoBizlogParams();
        bizlogParams.setOffset(Integer.valueOf(offset));
        bizlogParams.setMax(Integer.valueOf(pageSize));
        bizlogParams.setBizType(Integer.valueOf(BizLogTypeEnum.MERCHANT_ORDER_EXPORT.getCode()));
        PagenationDto qihoBizlogDtoPages = this.remoteBizlogBackendService.findPage(bizlogParams);
        Pagenation<QihoBizlogVO> pagenation = new Pagenation<QihoBizlogVO>();
        qihoBizlogDtoPages.getList();
        List qihoBizlogDtos = qihoBizlogDtoPages.getList();
        pagenation.setList(this.getQihoBizlogVOs(qihoBizlogDtos));
        pagenation.setTotal(qihoBizlogDtoPages.getTotal());
        return pagenation;
    }

    private List<QihoBizlogVO> getQihoBizlogVOs(List<QihoBizlogDto> qihoBizlogDtos) {
        if (CollectionUtils.isEmpty(qihoBizlogDtos)) {
            return Collections.emptyList();
        }
        ArrayList<QihoBizlogVO> qihoBizlogVOS = new ArrayList<QihoBizlogVO>();
        for (QihoBizlogDto dto : qihoBizlogDtos) {
            QihoBizlogVO bizlogVO = new QihoBizlogVO();
            bizlogVO.setId(dto.getId());
            bizlogVO.setBizStatus(dto.getBizStatus());
            bizlogVO.setBizStatusDesc(BizLogStatusEnum.getByCode((int)dto.getBizStatus()).getDesc());
            bizlogVO.setDownloadUrl(dto.getBizResult());
            JSONObject json = JSONObject.parseObject((String)dto.getPreCondition());
            String fileName = json.getString("fileName");
            StringBuilder sb = new StringBuilder();
            sb.append(dto.getOperator()).append("_").append(fileName).append(".csv");
            bizlogVO.setFileName(sb.toString());
            qihoBizlogVOS.add(bizlogVO);
        }
        return qihoBizlogVOS;
    }
}

