/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.finance.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.BaseResultDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDetailDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDto;
import com.qiho.center.api.enums.finance.BaiqiFinanceRechargeStateEnum;
import com.qiho.center.api.params.finance.BaiqiFinanceRechargeQryParam;
import com.qiho.center.api.remoteservice.finance.RemoteBaiqiFinanceRechargeBackendService;
import com.qiho.manager.biz.params.finance.FinanceRechargeParam;
import com.qiho.manager.biz.service.finance.BaiqiFinanceRechargeService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.finance.FinanceRechargeInfoVO;
import com.qiho.manager.common.util.BigDecimalUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="baiqiFinanceRechargeService")
public class BaiqiFinanceRechargeServiceImpl
implements BaiqiFinanceRechargeService {
    @Resource
    private RemoteBaiqiFinanceRechargeBackendService remoteBaiqiFinanceRechargeBackendService;

    @Override
    public Pagenation<FinanceRechargeInfoVO> findPage(BaiqiFinanceRechargeQryParam queryParams) {
        Pagenation<FinanceRechargeInfoVO> page = new Pagenation<FinanceRechargeInfoVO>();
        PagenationDto result = this.remoteBaiqiFinanceRechargeBackendService.find4Page(queryParams);
        page.setTotal(result.getTotal());
        if (result.getTotal() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        page.setList(this.mergeVo(result.getList()));
        return page;
    }

    private List<FinanceRechargeInfoVO> mergeVo(List<BaiqiFinanceRechargeDetailDto> list) {
        ArrayList<FinanceRechargeInfoVO> vos = new ArrayList<FinanceRechargeInfoVO>();
        for (BaiqiFinanceRechargeDetailDto dto : list) {
            FinanceRechargeInfoVO vo = new FinanceRechargeInfoVO();
            vo.setStateValue(BaiqiFinanceRechargeStateEnum.getByState((int)dto.getState()).getDesc());
            vo.setState(dto.getState());
            vo.setCashSum(BigDecimalUtil.integerToMove2PointLeft((Integer)dto.getCashSum()));
            vo.setCommercialTenantId(dto.getCommercialTenantId());
            vo.setCommercialTenantName(dto.getCommercialTenantName());
            vo.setCreator(dto.getCreator());
            vo.setGmtCreate(dto.getGmtCreate());
            vo.setRebateSum(BigDecimalUtil.integerToMove2PointLeft((Integer)dto.getRebateSum()));
            vo.setRechargeNo(dto.getRechargeNo());
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public Boolean submit(FinanceRechargeParam rechargeParam) {
        BaiqiFinanceRechargeDto dto = (BaiqiFinanceRechargeDto)BeanUtils.copy((Object)rechargeParam, BaiqiFinanceRechargeDto.class);
        String name = RequestTool.getAdmin().getName();
        dto.setCreator(name);
        dto.setOperator(name);
        dto.setState(Integer.valueOf(BaiqiFinanceRechargeStateEnum.WAIT_AID.getState()));
        return this.remoteBaiqiFinanceRechargeBackendService.rechargeSubmit(dto);
    }

    @Override
    public BaseResultDto audit(Long rechargeNo, Integer state) {
        return this.remoteBaiqiFinanceRechargeBackendService.audit(rechargeNo, state, RequestTool.getAdmin().getName());
    }

    @Override
    public BaiqiFinanceRechargeDetailDto find(Long rechargeNo) {
        return this.remoteBaiqiFinanceRechargeBackendService.findByNo(rechargeNo);
    }
}

