/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.AfterSaleOrderDto;
import com.qiho.center.api.dto.AfterSaleStageDto;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.AfterSaleOrderReasonEnum;
import com.qiho.center.api.enums.AfterSaleOrderStageEnum;
import com.qiho.center.api.enums.AfterSaleOrderStatusEnum;
import com.qiho.center.api.enums.AfterSaleOrderTypeEnum;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.params.AfterSaleQueryParams;
import com.qiho.center.api.remoteservice.order.RemoteAfterSaleOrderService;
import com.qiho.center.api.remoteservice.order.RemoteFundOrderService;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.manager.biz.service.AfterSaleOrderService;
import com.qiho.manager.biz.vo.AfterSaleVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AfterSaleOrderServiceImpl
implements AfterSaleOrderService {
    @Resource
    private RemoteAfterSaleOrderService afterSaleOrderService;
    @Resource
    private RemoteOrderService remoteOrderService;
    @Resource
    private RemoteFundOrderService remoteFundOrderService;

    @Override
    public String saveAfterSale(AfterSaleOrderDto param) {
        if (!this.checkParam(param).booleanValue()) {
            throw new QihoManagerException("\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u53ef\u9000\u6b3e\u603b\u91d1\u989d");
        }
        return this.afterSaleOrderService.save(param);
    }

    @Override
    public Pagenation<AfterSaleVO> queryAfterSale(AfterSaleQueryParams queryParams) {
        PagenationDto resultBase = this.afterSaleOrderService.queryAfterSaleByQuery(queryParams);
        Pagenation<AfterSaleVO> pagenation = new Pagenation<AfterSaleVO>();
        pagenation.setTotal(resultBase.getTotal());
        List afterSaleOrderDtoList = resultBase.getList();
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderDtoList)) {
            List orderIds = afterSaleOrderDtoList.stream().map(AfterSaleOrderDto::getOrderId).collect(Collectors.toList());
            List snapshotDtos = this.remoteOrderService.queryOrderByOrderIds(orderIds);
            List afterSaleVOS = afterSaleOrderDtoList.stream().map(e -> this.dtoToVo((AfterSaleOrderDto)e, snapshotDtos)).collect(Collectors.toList());
            pagenation.setList(afterSaleVOS);
        }
        return pagenation;
    }

    @Override
    public Boolean updateAfterSale(AfterSaleOrderDto param) {
        AfterSaleStageDto afterSaleStageDto = new AfterSaleStageDto();
        afterSaleStageDto.setUpdateTime(DateUtils.getSecondStr((Date)new Date()));
        switch (AfterSaleOrderStatusEnum.getByCode((String)param.getAfterSaleStatus())) {
            case AFTER_SALEING: {
                afterSaleStageDto.setType(AfterSaleOrderStageEnum.ITEM_RECEIVE.getCode());
                break;
            }
            case SUCCESS: {
                afterSaleStageDto.setType(AfterSaleOrderStageEnum.REFUND_SUCCESS.getCode());
                break;
            }
            case CANCLE: {
                afterSaleStageDto.setType(AfterSaleOrderStageEnum.CANCEL.getCode());
                break;
            }
        }
        param.setDetailStage(Stream.of(afterSaleStageDto).collect(Collectors.toList()));
        return this.afterSaleOrderService.updateAfterSaleByDto(param);
    }

    private AfterSaleVO dtoToVo(AfterSaleOrderDto dto, List<OrderSnapshotDto> snapshotDtos) {
        AfterSaleVO afterSaleVO = (AfterSaleVO)BeanUtils.copy((Object)dto, AfterSaleVO.class);
        afterSaleVO.setAfterSaleReason(AfterSaleOrderReasonEnum.getByCode((String)dto.getAfterSaleReason()).getMsg());
        afterSaleVO.setAfterSaleStatus(AfterSaleOrderStatusEnum.getByCode((String)dto.getAfterSaleStatus()).getMsg());
        afterSaleVO.setAfterSaleType(AfterSaleOrderTypeEnum.getByCode((String)dto.getAfterSaleType()).getDesc());
        afterSaleVO.setGmtCreate(DateUtils.getSecondStr((Date)dto.getGmtCreate()));
        afterSaleVO.setGmtModified(DateUtils.getSecondStr((Date)dto.getGmtModified()));
        afterSaleVO.setFreightAmt(dto.getRefreightAmt());
        for (OrderSnapshotDto orderSnapshotDto : snapshotDtos) {
            if (!afterSaleVO.getOrderId().equals(orderSnapshotDto.getOrderId())) continue;
            afterSaleVO.setOrderGmtModified(DateUtils.getSecondStr((Date)orderSnapshotDto.getGmtCreate()));
            break;
        }
        return afterSaleVO;
    }

    private Boolean checkParam(AfterSaleOrderDto param) {
        String orderId = param.getOrderId();
        DubboResult result = this.remoteOrderService.findByOrderId(orderId);
        if (!result.isSuccess() || null == result.getResult()) {
            throw new QihoManagerException("\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OrderDto orderDto = (OrderDto)result.getResult();
        Integer countAmt = orderDto.getOrderAmt();
        Integer alreadRefund = 0;
        List afterSaleOrderDtos = this.afterSaleOrderService.queryAfterSaleByOrderId(orderId);
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderDtos)) {
            for (AfterSaleOrderDto afterSaleOrderDto : afterSaleOrderDtos) {
                AfterSaleOrderStatusEnum statusEnum = AfterSaleOrderStatusEnum.getByCode((String)afterSaleOrderDto.getAfterSaleStatus());
                if (statusEnum == AfterSaleOrderStatusEnum.SUCCESS || statusEnum == AfterSaleOrderStatusEnum.CANCLE) continue;
                throw new QihoManagerException("\u5df2\u7ecf\u5b58\u5728\u53d1\u7684\u552e\u540e,\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77");
            }
            alreadRefund = alreadRefund + this.checkAmt(orderId);
        }
        if (countAmt >= alreadRefund + param.getRefundAmt()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Integer checkAmt(String orderId) {
        List fundOrderDtos;
        List flight;
        Integer baseAmt = 0;
        DubboResult dubboResult = this.remoteFundOrderService.findByOrderIdAndBizType(orderId, FundBizTypeEnum.REFUND.getCode());
        if (null != dubboResult && dubboResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)dubboResult.getResult())) && CollectionUtils.isNotEmpty(flight = (fundOrderDtos = (List)dubboResult.getResult()).stream().filter(e -> FundStatusEnum.getEnumByCode((String)e.getFundStatus()) == FundStatusEnum.SUCCESS).collect(Collectors.toList()))) {
            for (FundOrderDto fundOrderDto : flight) {
                baseAmt = baseAmt + fundOrderDto.getAmt();
            }
        }
        return baseAmt;
    }
}

