/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.BannerDto;
import com.qiho.center.api.enums.BannerTypeEnum;
import com.qiho.center.api.remoteservice.RemoteBannerService;
import com.qiho.manager.biz.service.BannerService;
import com.qiho.manager.biz.vo.BannerVO;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BannerServiceImpl
implements BannerService {
    @Autowired
    private RemoteBannerService remoteBannerService;

    @Override
    public List<BannerVO> getBannerList(String bannerType) {
        List bannerDtos = (List)this.remoteBannerService.getAllBanners(bannerType).getResult();
        return this.convertToVOList(bannerDtos);
    }

    @Override
    public BannerVO findBannerById(Long id) {
        BannerDto dto = (BannerDto)this.remoteBannerService.getBannerById(id).getResult();
        if (dto.getId() == null) {
            throw new QihoManagerException("Banner\u4e0d\u5b58\u5728");
        }
        return this.convertToVOList(Lists.newArrayList((Object[])new BannerDto[]{dto})).get(0);
    }

    @Override
    public Boolean saveBanner(BannerDto dto) {
        Boolean result = null;
        switch (dto.getBannerType()) {
            case CAROUSEL: {
                result = this.saveCarousel(dto);
                break;
            }
            case RECOMMEND: {
                result = this.saveRecommend(dto);
                break;
            }
        }
        return result;
    }

    private Boolean saveCarousel(BannerDto dto) {
        if (dto.getPayload() == null) {
            int maxPayload = (Integer)this.remoteBannerService.findMaxPayload().getResult();
            dto.setPayload(Integer.valueOf(++maxPayload));
        }
        return (Boolean)this.remoteBannerService.saveBanner(dto).getResult();
    }

    private Boolean saveRecommend(BannerDto dto) {
        List bannerList = (List)this.remoteBannerService.getAllBanners(BannerTypeEnum.RECOMMEND.getCode()).getResult();
        dto.setPayload(Integer.valueOf(0));
        if (CollectionUtils.isEmpty((Collection)bannerList)) {
            return (Boolean)this.remoteBannerService.saveBanner(dto).getResult();
        }
        for (BannerDto banner : bannerList) {
            if (dto.getStartTime().getTime() >= banner.getEndTime().getTime() || dto.getEndTime().getTime() <= banner.getStartTime().getTime() || dto.getId().intValue() == banner.getId().intValue()) continue;
            throw new QihoManagerException("\u751f\u6548\u5468\u671f\u9519\u8bef");
        }
        return (Boolean)this.remoteBannerService.saveBanner(dto).getResult();
    }

    private List<BannerVO> convertToVOList(List<BannerDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Lists.newArrayList();
        }
        ArrayList<BannerVO> bannerVOList = new ArrayList<BannerVO>();
        for (BannerDto dto : dtoList) {
            BannerVO bannerVO = (BannerVO)BeanUtils.copy((Object)dto, BannerVO.class);
            bannerVO.setBannerType(dto.getBannerType().getCode());
            bannerVO.setStartTime(DateUtils.getSecondStr((Date)dto.getStartTime()));
            bannerVO.setEndTime(DateUtils.getSecondStr((Date)dto.getEndTime()));
            bannerVO.setGmtCreate(DateUtils.getSecondStr((Date)dto.getGmtCreate()));
            bannerVO.setGmtModified(DateUtils.getSecondStr((Date)dto.getGmtModified()));
            bannerVOList.add(bannerVO);
        }
        return bannerVOList;
    }
}

