/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.finance.FinanceDetailDto;
import com.qiho.center.api.dto.finance.FinanceDto;
import com.qiho.center.api.dto.finance.HistoricalBalanceDto;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.params.finance.BaiqiMerchantFreetextParam;
import com.qiho.center.api.params.finance.FinanceBasePageParam;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentBackendService;
import com.qiho.center.api.remoteservice.finance.RemoteFinanceDetailService;
import com.qiho.center.api.remoteservice.finance.RemoteFinanceService;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantService;
import com.qiho.manager.biz.service.finance.FinanceService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.account.IdAndNameVO;
import com.qiho.manager.biz.vo.merchant.FinanceBaseInfoVo;
import com.qiho.manager.biz.vo.merchant.FinanceDetailVo;
import com.qiho.manager.biz.vo.merchant.HistoricalBalanceVo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FinanceServiceImpl
implements FinanceService {
    @Autowired
    private RemoteFinanceService remoteFinanceService;
    @Autowired
    private RemoteBaiqiAgentBackendService remoteBaiqiAgentBackendService;
    @Autowired
    private RemoteFinanceDetailService remoteFinanceDetailService;
    @Autowired
    private RemoteMerchantService remoteMerchantService;

    @Override
    public Pagenation<FinanceBaseInfoVo> findAllFinanceBaseInfo(FinanceBasePageParam pageParam) {
        Pagenation<FinanceBaseInfoVo> page = new Pagenation<FinanceBaseInfoVo>();
        PagenationDto pagenationDto = this.remoteFinanceService.findAll(pageParam);
        page.setTotal(pagenationDto.getTotal());
        if (pagenationDto.getTotal() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        List financeBaseInfoVos = pagenationDto.getList().stream().map(this::financeBasedtoToVo).collect(Collectors.toList());
        page.setList(financeBaseInfoVos);
        return page;
    }

    @Override
    public Pagenation<FinanceDetailVo> findDetailByPara(BaiqiMerchantFreetextParam param) {
        PagenationDto detialDtos = this.remoteFinanceDetailService.findByParams(param);
        return this.getPageVo((PagenationDto<FinanceDetailDto>)detialDtos);
    }

    @Override
    public List<IdAndNameVO> querySimpleInfo(Integer type) {
        List merchantSpacialDtos = type.intValue() == FinanceTypeEnum.MAIN_ACCOUNT.getCode() ? this.remoteMerchantService.findAllMerchantSimple() : this.remoteBaiqiAgentBackendService.findAgentSimple();
        return BeanUtils.copyList((List)merchantSpacialDtos, IdAndNameVO.class);
    }

    @Override
    public Pagenation<HistoricalBalanceVo> findHistoricalBalanceByPara(BaiqiMerchantFreetextParam param) {
        PagenationDto historicalBalanceDtos = this.remoteFinanceDetailService.findHistoricalBalanceByPara(param);
        List historicalBalanceVos = historicalBalanceDtos.getList().stream().map(this::historicalBalanceDtoToVo).collect(Collectors.toList());
        Pagenation<HistoricalBalanceVo> pagenationDto = new Pagenation<HistoricalBalanceVo>();
        pagenationDto.setTotal(historicalBalanceDtos.getTotal());
        pagenationDto.setList(historicalBalanceVos);
        return pagenationDto;
    }

    private Pagenation<FinanceDetailVo> getPageVo(PagenationDto<FinanceDetailDto> detialDtos) {
        List financeDetailVos = detialDtos.getList().stream().map(this::financeDetialdtoToVo).collect(Collectors.toList());
        Pagenation<FinanceDetailVo> pagenationDto = new Pagenation<FinanceDetailVo>();
        pagenationDto.setTotal(detialDtos.getTotal());
        pagenationDto.setList(financeDetailVos);
        return pagenationDto;
    }

    private FinanceBaseInfoVo financeBasedtoToVo(FinanceDto detailDto) {
        FinanceBaseInfoVo financeBaseInfoVo = (FinanceBaseInfoVo)BeanUtils.copy((Object)detailDto, FinanceBaseInfoVo.class);
        financeBaseInfoVo.setGmtCreate(DateUtils.getSecondStr((Date)detailDto.getGmtCreate()));
        financeBaseInfoVo.setGmtModified(DateUtils.getSecondStr((Date)detailDto.getGmtModified()));
        Long totalAmount = detailDto.getTotalAmount();
        Long cashAmount = detailDto.getCashAmount();
        Long rebateAmount = detailDto.getRebateAmount();
        financeBaseInfoVo.setTotalAmount(totalAmount == null ? "0" : new BigDecimal(totalAmount).movePointLeft(2).toString());
        financeBaseInfoVo.setCashAmount(cashAmount == null ? "0" : new BigDecimal(cashAmount).movePointLeft(2).toString());
        financeBaseInfoVo.setRebateAmount(rebateAmount == null ? "0" : new BigDecimal(rebateAmount).movePointLeft(2).toString());
        financeBaseInfoVo.setRelationType(detailDto.getRelationType() == null ? null : detailDto.getRelationType().getTypeName());
        financeBaseInfoVo.setState(detailDto.getState().getCode());
        return financeBaseInfoVo;
    }

    private FinanceDetailVo financeDetialdtoToVo(FinanceDetailDto detailDto) {
        FinanceDetailVo financeDetailVo = (FinanceDetailVo)BeanUtils.copy((Object)detailDto, FinanceDetailVo.class);
        financeDetailVo.setGmtCreate(DateUtils.getDayStr((Date)detailDto.getGmtCreate()));
        financeDetailVo.setGmtModified(DateUtils.getDayStr((Date)detailDto.getGmtModified()));
        Long incomeTotal = detailDto.getIncomeTotal();
        Long incomeCash = detailDto.getIncomeCash();
        Long incomeRebate = detailDto.getIncomeRebate();
        Long expenditureTotal = detailDto.getExpenditureTotal();
        Long expenditureCash = detailDto.getExpenditureCash();
        Long expenditureRebate = detailDto.getExpenditureRebate();
        financeDetailVo.setIncomeTotal(incomeTotal == null ? "0" : new BigDecimal(incomeTotal).movePointLeft(2).toString());
        financeDetailVo.setIncomeCash(incomeCash == null ? "0" : new BigDecimal(incomeCash).movePointLeft(2).toString());
        financeDetailVo.setIncomeRebate(incomeRebate == null ? "0" : new BigDecimal(incomeRebate).movePointLeft(2).toString());
        financeDetailVo.setExpenditureTotal(expenditureTotal == null ? "0" : new BigDecimal(expenditureTotal).movePointLeft(2).toString());
        financeDetailVo.setExpenditureCash(expenditureCash == null ? "0" : new BigDecimal(expenditureCash).movePointLeft(2).toString());
        financeDetailVo.setExpenditureRebate(expenditureRebate == null ? "0" : new BigDecimal(expenditureRebate).movePointLeft(2).toString());
        if (detailDto.getRelationType().getCode() == 1) {
            BaiqiAgentDto agentDto = this.remoteBaiqiAgentBackendService.findAgentByMerchantId(detailDto.getRelationId().toString());
            if (agentDto == null) {
                financeDetailVo.setRelationType(detailDto.getRelationType().getTypeName() + " (\u65e0\u4ee3\u7406\u5546)");
            } else {
                financeDetailVo.setRelationType(detailDto.getRelationType().getTypeName() + " (\u4ee3\u7406\u5546: " + agentDto.getAgentName() + ")");
            }
        } else if (detailDto.getRelationType().getCode() == 2) {
            financeDetailVo.setRelationType(detailDto.getRelationType().getTypeName());
        }
        financeDetailVo.setOperatorType(detailDto.getOperatorType().getDesc());
        financeDetailVo.setState(detailDto.getState().getCode());
        return financeDetailVo;
    }

    private HistoricalBalanceVo historicalBalanceDtoToVo(HistoricalBalanceDto historicalBalanceDto) {
        HistoricalBalanceVo historicalBalanceVo = (HistoricalBalanceVo)BeanUtils.copy((Object)historicalBalanceDto, HistoricalBalanceVo.class);
        historicalBalanceVo.setGmtCreate(DateUtils.getDayStr((Date)historicalBalanceDto.getGmtCreate()));
        historicalBalanceVo.setGmtModified(DateUtils.getDayStr((Date)historicalBalanceDto.getGmtModified()));
        historicalBalanceVo.setReportDate(DateUtils.getDayStr((Date)historicalBalanceDto.getReportDate()));
        Long totalAmount = historicalBalanceDto.getTotalAmount();
        Long cashAmount = historicalBalanceDto.getCashAmount();
        Long rebateAmount = historicalBalanceDto.getRebateAmount();
        historicalBalanceVo.setTotalAmount(totalAmount == null ? "0" : new BigDecimal(totalAmount).movePointLeft(2).toString());
        historicalBalanceVo.setCashAmount(cashAmount == null ? "0" : new BigDecimal(cashAmount).movePointLeft(2).toString());
        historicalBalanceVo.setRebateAmount(rebateAmount == null ? "0" : new BigDecimal(rebateAmount).movePointLeft(2).toString());
        historicalBalanceVo.setRelationType(historicalBalanceDto.getRelationType() == null ? null : historicalBalanceDto.getRelationType().getTypeName());
        return historicalBalanceVo;
    }
}

