/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.FundPageParam;
import com.qiho.center.api.remoteservice.order.RemoteFundOrderService;
import com.qiho.manager.biz.service.FundOrderService;
import com.qiho.manager.biz.vo.FundOrderVO;
import com.qiho.manager.biz.vo.Pagenation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FundOrderServiceImpl
implements FundOrderService {
    @Autowired
    private RemoteFundOrderService remoteFundOrderService;

    @Override
    public Pagenation<FundOrderVO> queryList(FundPageParam param) {
        DubboResult result = this.remoteFundOrderService.queryFundPage(param);
        Pagenation<FundOrderVO> page = new Pagenation<FundOrderVO>();
        page.setTotal(((PagenationDto)result.getResult()).getTotal());
        List list = ((PagenationDto)result.getResult()).getList();
        ArrayList fundList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (FundOrderDto fundDto : list) {
                FundOrderVO vo = new FundOrderVO();
                vo.setAmt(fundDto.getAmt());
                vo.setFundId(fundDto.getFundId());
                vo.setFundStatus(FundStatusEnum.getEnumByCode((String)fundDto.getFundStatus()).getDesc());
                vo.setGmtCreate(DateUtils.getSecondStr((Date)fundDto.getGmtCreate()));
                vo.setGmtModified(DateUtils.getSecondStr((Date)fundDto.getGmtModified()));
                vo.setOrderId(fundDto.getOrderId());
                vo.setOutSeqNo(fundDto.getOutSeqNo());
                vo.setPayType(PayTypeEnum.getEnumByCode((String)fundDto.getPayType()).getDesc());
                vo.setBizType(FundBizTypeEnum.getByCode((String)fundDto.getBizType()).getDesc());
                fundList.add(vo);
            }
        }
        page.setList(fundList);
        return page;
    }
}

