/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.advert.ItemBindPlanParams;
import com.qiho.center.api.params.advert.ItemPlanQueryParams;
import com.qiho.center.api.params.data.ItemDataQueryParam;
import com.qiho.center.api.remoteservice.advert.RemoteItemPlanService;
import com.qiho.center.api.remoteservice.data.RemoteGoodsDataService;
import com.qiho.manager.biz.service.ItemPlanService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.advert.ItemCostVO;
import com.qiho.manager.biz.vo.advert.ItemPlanVO;
import com.qiho.manager.biz.vo.advert.TuiaPlanVO;
import com.qiho.manager.common.exception.QihoManagerException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemPlanServiceImpl
implements ItemPlanService {
    @Autowired
    private RemoteItemPlanService remoteItemPlanService;
    @Autowired
    private RemoteGoodsDataService remoteGoodsDataService;

    @Override
    public Pagenation<ItemPlanVO> queryList(Long itemId, String itemName, Integer pageNum, Integer pageSize) {
        Pagenation<ItemPlanVO> page = new Pagenation<ItemPlanVO>();
        ItemPlanQueryParams params = new ItemPlanQueryParams();
        params.setItemId(itemId);
        params.setItemName(itemName);
        params.setPageNum(pageNum);
        params.setPageSize(pageSize);
        PagenationDto result = this.remoteItemPlanService.queryPage(params);
        Integer total = result.getTotal();
        page.setTotal(total);
        if (total == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        List itemPlanList = result.getList();
        List list = Lists.transform((List)itemPlanList, itemPlan -> {
            ItemPlanVO vo = (ItemPlanVO)BeanUtils.copy((Object)itemPlan, ItemPlanVO.class);
            vo.setPlanList(BeanUtils.copyList((List)itemPlan.getAdvertList(), TuiaPlanVO.class));
            return vo;
        });
        page.setList(list);
        return page;
    }

    @Override
    public List<TuiaPlanVO> findPlan(Long itemId) {
        List dtoList = this.remoteItemPlanService.getUnbindPlan(itemId);
        return BeanUtils.copyList((List)dtoList, TuiaPlanVO.class);
    }

    @Override
    public Boolean bindPlan(Long itemId, List<Long> planList) {
        if (CollectionUtils.isEmpty(planList)) {
            throw new QihoManagerException("\u4f20\u5165\u7684\u5e7f\u544a\u8ba1\u5212\u5217\u8868\u4e3a\u7a7a");
        }
        ItemBindPlanParams planParams = new ItemBindPlanParams();
        planParams.setCreater(RequestTool.getAdminId());
        planParams.setModifier(RequestTool.getAdminId());
        planParams.setItemId(itemId);
        planParams.setPlanList(planList);
        Boolean result = false;
        try {
            result = this.remoteItemPlanService.bingPlan(planParams);
        }
        catch (Exception e) {
            throw new QihoManagerException(e.getMessage());
        }
        return result;
    }

    @Override
    public Pagenation<ItemCostVO> queryData(Long itemid, String itemName, Date startTime, Date endTime, Integer pageNum, Integer pageSize) {
        Pagenation<ItemCostVO> page = new Pagenation<ItemCostVO>();
        ItemDataQueryParam param = new ItemDataQueryParam();
        param.setItemId(itemid);
        param.setItemName(itemName);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setOffset(Integer.valueOf((pageNum - 1) * pageSize));
        param.setMax(pageSize);
        PagenationDto result = this.remoteGoodsDataService.queryPage(param);
        Integer total = result.getTotal();
        page.setTotal(total);
        if (total == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        List list = Lists.transform((List)result.getList(), dto -> {
            ItemCostVO vo = new ItemCostVO();
            vo.setItemId(dto.getItemId());
            vo.setItemName(dto.getItemName());
            vo.setClick(String.valueOf(dto.getClick()));
            vo.setCost(ItemPlanServiceImpl.fenToYuan(dto.getCost()));
            vo.setExpose(String.valueOf(dto.getExpose()));
            return vo;
        });
        page.setList(list);
        return page;
    }

    public static String fenToYuan(Long amount) {
        if (amount == null) {
            return "0.00";
        }
        return new BigDecimal(amount).divide(new BigDecimal(100), 2, 7).toString();
    }
}

