/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.monitor.LogisticsMonitorPlanDto;
import com.qiho.center.api.enums.AreaEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.MonitorPlanQueryParam;
import com.qiho.center.api.remoteservice.monitor.RemoteLogisticsMonitorPlanService;
import com.qiho.manager.biz.service.LogisticsMonitorPlanService;
import com.qiho.manager.biz.service.logistics.LogisticsService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.monitor.LogisticsMonitorPlanVO;
import com.qiho.manager.biz.vo.monitor.MonitorStrategyVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LogisticsMonitorPlanServiceImpl
implements LogisticsMonitorPlanService {
    @Resource
    private RemoteLogisticsMonitorPlanService remoteLogisticsMonitorPlanService;
    @Resource
    private LogisticsService logisticsService;

    @Override
    public Pagenation<LogisticsMonitorPlanVO> queryPageList(MonitorPlanQueryParam queryParam) {
        Pagenation<LogisticsMonitorPlanVO> pagenation = new Pagenation<LogisticsMonitorPlanVO>();
        PagenationDto pagenationDto = this.remoteLogisticsMonitorPlanService.queryPageList(queryParam);
        pagenation.setTotal(pagenationDto.getTotal());
        if (pagenation.getTotal() == 0) {
            pagenation.setList(Lists.newArrayList());
            return pagenation;
        }
        ArrayList list = Lists.newArrayList();
        Map<String, String> map = this.logisticsService.getBaiqiLogisticsCodeToName();
        pagenationDto.getList().forEach(dto -> {
            LogisticsMonitorPlanVO vo = (LogisticsMonitorPlanVO)BeanUtils.copy((Object)dto, LogisticsMonitorPlanVO.class);
            vo.setStartTime(DateUtils.getDayStr((Date)dto.getStartTime()));
            vo.setEndTime(DateUtils.getDayStr((Date)dto.getEndTime()));
            vo.setLogisticsName((String)map.get(vo.getLogisticsCode()));
            list.add(vo);
        });
        pagenation.setList(list);
        return pagenation;
    }

    @Override
    public int saveLogisticsMonitorPlan(LogisticsMonitorPlanDto dto) {
        try {
            return this.remoteLogisticsMonitorPlanService.createMonitorPlan(dto);
        }
        catch (BizException e) {
            throw new QihoException(e.getMessage());
        }
    }

    @Override
    public LogisticsMonitorPlanVO queryPlanDetailById(Long id) {
        LogisticsMonitorPlanDto planDto = this.remoteLogisticsMonitorPlanService.selectDetailById(id);
        LogisticsMonitorPlanVO planVO = (LogisticsMonitorPlanVO)BeanUtils.copy((Object)planDto, LogisticsMonitorPlanVO.class);
        planVO.setLogisticsName(this.logisticsService.getBaiqiLogisticsCodeToName().get(planVO.getLogisticsCode()));
        planVO.setStartTime(DateUtils.getDayStr((Date)planDto.getStartTime()));
        planVO.setEndTime(DateUtils.getDayStr((Date)planDto.getEndTime()));
        List strategyList = BeanUtils.copyList((List)planDto.getStrategyDtoList(), MonitorStrategyVO.class);
        strategyList.stream().forEach(strategy -> {
            strategy.setWarehouseName("\u5bcc\u9633\u4ed3\u5e93");
            if (StringUtils.equals((CharSequence)strategy.getMonitorStatus(), (CharSequence)OrderStatusEnum.TO_SEND.getCode())) {
                strategy.setMonitorStatusName(OrderStatusEnum.TO_SEND.getDesc());
            } else {
                strategy.setMonitorStatusName(LogisticsOrderStatusEnum.getByCode((String)strategy.getMonitorStatus()).getDesc());
            }
            strategy.setAreaInfoName(this.transformCodeToName(strategy.getAreaInfo()));
        });
        planVO.setStrategyList(strategyList);
        return planVO;
    }

    @Override
    public int deleteById(Long id) {
        return this.remoteLogisticsMonitorPlanService.deleteMonitorPlan(id);
    }

    private String transformCodeToName(String codeStr) {
        List codesList = Splitter.on((String)",").trimResults().splitToList((CharSequence)codeStr);
        StringBuilder sb = new StringBuilder();
        codesList.stream().forEach(code -> {
            AreaEnum area = AreaEnum.getAreaEnumByCode((String)code);
            sb.append(area.getName()).append(",");
        });
        return sb.toString().substring(0, sb.length() - 1);
    }
}

