/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaWhiteListDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.MediaWhiteListQueryParam;
import com.qiho.center.api.remoteservice.campaign.RemoteMediaWhiteListService;
import com.qiho.manager.biz.service.MediaWhiteListService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.WhiteListVO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MediaWhiteListServiceImpl
implements MediaWhiteListService {
    @Resource
    private RemoteMediaWhiteListService remoteMediaWhiteListService;

    @Override
    public Long saveOrUpdateWhiteList(MediaWhiteListDto mediaWhiteListDto) {
        DubboResult result = this.remoteMediaWhiteListService.saveOrUpdateWhiteList(mediaWhiteListDto);
        if (!result.isSuccess()) {
            throw new QihoException(result.getMsg());
        }
        return (Long)result.getResult();
    }

    @Override
    public Integer deleteWhiteList(Long id) {
        DubboResult result = this.remoteMediaWhiteListService.deleteWhiteListById(id);
        if (result.isSuccess()) {
            return (Integer)result.getResult();
        }
        throw new QihoException(result.getMsg());
    }

    @Override
    public Pagenation<WhiteListVO> queryWhiteListByPage(MediaWhiteListQueryParam param) {
        DubboResult result = this.remoteMediaWhiteListService.queryWhiteListPage(param);
        if (!result.isSuccess()) {
            throw new QihoException(result.getMsg());
        }
        Pagenation<WhiteListVO> page = new Pagenation<WhiteListVO>();
        PagenationDto pagenationDto = (PagenationDto)result.getResult();
        page.setTotal(pagenationDto.getTotal());
        page.setList(BeanUtils.copyList((List)pagenationDto.getList(), WhiteListVO.class));
        return page;
    }

    @Override
    public WhiteListVO selectWhiteListById(Long id) {
        DubboResult result = this.remoteMediaWhiteListService.selectWhiteListById(id);
        if (!result.isSuccess()) {
            throw new QihoException(result.getMsg());
        }
        return (WhiteListVO)BeanUtils.copy((Object)result.getResult(), WhiteListVO.class);
    }
}

