/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.OpenInterfaceDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSpacialDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.OpenInterfaceTypeEnum;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.api.params.MerchantQueryParams;
import com.qiho.center.api.params.OpenInterfaceQueryParams;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentService;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantService;
import com.qiho.manager.biz.service.MerchantService;
import com.qiho.manager.biz.vo.MerchantSimpleVO;
import com.qiho.manager.biz.vo.OpenInterfaceVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.merchant.MerchantVO;
import com.qiho.manager.biz.vo.merchant.SpecialSimpleVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.AppSecretUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantSerivceImpl
implements MerchantService {
    public static final String APP_KEY_AGENT_PREFIX = "a";
    @Autowired
    private RemoteMerchantService remoteMerchantService;
    @Autowired
    private RemoteBaiqiAgentService remoteBaiqiAgentService;
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;
    @Autowired
    private RemoteAdminService remoteAdminService;

    @Override
    public Boolean saveMerchant(MerchantDto dto) {
        if (dto.getId() == null) {
            dto.setGmtCreator(RequestTool.getAdminId());
            dto.setGmtCreate(new Date());
        }
        dto.setGmtModified(new Date());
        dto.setGmtModifier(RequestTool.getAdminId());
        dto.setOwnerAeId(RequestTool.getAdminId());
        try {
            return this.remoteMerchantService.saveMerchant(dto);
        }
        catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
    }

    @Override
    public MerchantVO findById(Long merchantId) {
        MerchantDto dto = this.remoteMerchantService.findById(merchantId);
        if (null == dto || dto.getId() == null) {
            throw new QihoManagerException("\u5546\u5bb6Id\u4e0d\u5b58\u5728");
        }
        MerchantVO merchantVO = (MerchantVO)BeanUtils.copy((Object)dto, MerchantVO.class);
        if (StringUtils.isNotBlank((CharSequence)merchantVO.getDelivery())) {
            merchantVO.setDelivery(DeliveryEnum.getByCode((String)merchantVO.getDelivery()).getDesc());
        }
        return merchantVO;
    }

    @Override
    public List<MerchantVO> listByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return Collections.emptyList();
        }
        List merchantDtoList = this.remoteMerchantService.findListByName(name.trim());
        if (CollectionUtils.isEmpty((Collection)merchantDtoList)) {
            return Lists.newArrayList();
        }
        return BeanUtils.copyList((List)merchantDtoList, MerchantVO.class);
    }

    @Override
    public Pagenation<MerchantVO> pageQuery(MerchantQueryParams params) {
        boolean flag = this.hasSeeAllPermission("seeAllMerchant");
        if (!flag) {
            params.setOwnerAeId(RequestTool.getAdminId());
        }
        Pagenation<MerchantVO> page = new Pagenation<MerchantVO>();
        PagenationDto result = this.remoteMerchantService.querypage(params);
        page.setTotal(result.getTotal());
        if (result.getTotal() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        List merchantDtos = result.getList();
        List aeIds = merchantDtos.stream().map(MerchantDto::getOwnerAeId).filter(Objects::nonNull).collect(Collectors.toList());
        List adminDtos = this.remoteAdminService.batchFindAdminByIds(aeIds);
        Map<Long, String> aeIdNameMap = adminDtos.stream().collect(Collectors.toMap(AdminDto::getId, AdminDto::getName, (o, n) -> o));
        List merchantVOList = Lists.transform((List)merchantDtos, e -> {
            MerchantVO merchantVO = (MerchantVO)BeanUtils.copy((Object)e, MerchantVO.class);
            if (StringUtils.isNotBlank((CharSequence)merchantVO.getDelivery())) {
                merchantVO.setDelivery(DeliveryEnum.getByCode((String)merchantVO.getDelivery()).getDesc());
            }
            Long ownerAeId = e.getOwnerAeId();
            Optional.ofNullable(ownerAeId).ifPresent(tempOwnerAeId -> merchantVO.setOwnerAe((String)aeIdNameMap.get(tempOwnerAeId)));
            return merchantVO;
        });
        page.setList(merchantVOList);
        return page;
    }

    private boolean hasSeeAllPermission(String permissionCode) {
        return this.adminPowerCacheService.hasPower(RequestTool.getAdminId(), permissionCode);
    }

    @Override
    public String findByMerchantId(Long merchantId) {
        MerchantDto dto = this.remoteMerchantService.findById(merchantId);
        if (null == dto || dto.getId() == null) {
            throw new QihoManagerException("\u5546\u5bb6Id\u4e0d\u5b58\u5728");
        }
        MerchantVO merchantVO = (MerchantVO)BeanUtils.copy((Object)dto, MerchantVO.class);
        if (StringUtils.isNotBlank((CharSequence)merchantVO.getDelivery())) {
            merchantVO.setDelivery(DeliveryEnum.getByCode((String)merchantVO.getDelivery()).getDesc());
        }
        return merchantVO.getDelivery();
    }

    @Override
    public List<SpecialSimpleVO> findSimpleAll() {
        ArrayList<SpecialSimpleVO> vos = new ArrayList<SpecialSimpleVO>();
        List list = this.remoteMerchantService.findAll();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        for (MerchantSpacialDto dto : list) {
            SpecialSimpleVO vo = new SpecialSimpleVO();
            vo.setId(dto.getId());
            vo.setContactName(dto.getContactName());
            vo.setName(dto.getMerchantName());
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public Long findRelationId(Long merchantId, BaiqiMerchantLinkTypeEnum relationType) {
        return this.remoteMerchantService.findRelationIdByMerchantIdAndRelationType(merchantId, relationType);
    }

    @Override
    public Pagenation<OpenInterfaceVO> openInterfacePageQuery(OpenInterfaceQueryParams params) {
        PagenationDto result = this.remoteMerchantService.openInterfacePageQuery(params);
        Pagenation<OpenInterfaceVO> pagenation = new Pagenation<OpenInterfaceVO>();
        pagenation.setTotal(result.getTotal());
        pagenation.setList(this.dtoListToVoList(result.getList()));
        return pagenation;
    }

    private List<OpenInterfaceVO> dtoListToVoList(List<OpenInterfaceDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        return dtoList.stream().map(this::dtoToVo).collect(Collectors.toList());
    }

    private OpenInterfaceVO dtoToVo(OpenInterfaceDto dto) {
        if (dto == null) {
            return null;
        }
        OpenInterfaceVO openInterfaceVO = new OpenInterfaceVO();
        openInterfaceVO.setMerchantId(dto.getMerchantId());
        openInterfaceVO.setMerchantName(dto.getMerchantName());
        openInterfaceVO.setAppKey(dto.getAppkey());
        openInterfaceVO.setAppSecret(dto.getAppsecret());
        openInterfaceVO.setInterfaceType(dto.getInterfaceType());
        if (dto.getGmtCreate() != null || dto.getGmtModified() != null) {
            openInterfaceVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dto.getGmtCreate()));
            openInterfaceVO.setGmtModified(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dto.getGmtModified()));
        }
        return openInterfaceVO;
    }

    @Override
    public Boolean saveOpenInterface(Long merchantId) {
        MerchantDto dto = this.remoteMerchantService.findById(merchantId);
        if (null == dto || null == dto.getId()) {
            throw new QihoManagerException("\u5546\u5bb6Id\u4e0d\u5b58\u5728");
        }
        if (null != this.remoteMerchantService.findByMerchantId(merchantId)) {
            throw new QihoManagerException("\u8be5\u5546\u5bb6\u5df2\u5b58\u5728");
        }
        String appKey = merchantId.toString();
        if (null != this.remoteMerchantService.findByAppKey(appKey)) {
            throw new QihoManagerException("APPkey\u5df2\u5b58\u5728");
        }
        OpenInterfaceDto openInterfaceDto = new OpenInterfaceDto();
        openInterfaceDto.setMerchantId(merchantId);
        openInterfaceDto.setAppkey(appKey);
        openInterfaceDto.setAppsecret(AppSecretUtil.getAppSecret());
        openInterfaceDto.setGmtCreate(new Date());
        openInterfaceDto.setGmtModified(new Date());
        return this.remoteMerchantService.saveOpenInterface(openInterfaceDto);
    }

    @Override
    public Boolean saveAgentOpenInterface(Long agentId) {
        BaiqiAgentDto dto = this.remoteBaiqiAgentService.findBaiqiAgentById(agentId);
        if (null == dto || null == dto.getId()) {
            throw new QihoManagerException("\u4ee3\u7406\u5546Id\u4e0d\u5b58\u5728");
        }
        if (null != this.remoteBaiqiAgentService.findByAgentId(agentId)) {
            throw new QihoManagerException("\u8be5\u4ee3\u7406\u5546\u5df2\u5b58\u5728");
        }
        String appKey = agentId.toString();
        if (null != this.remoteMerchantService.findByAppKey(APP_KEY_AGENT_PREFIX + appKey)) {
            throw new QihoManagerException("APPkey\u5df2\u5b58\u5728");
        }
        OpenInterfaceDto openInterfaceDto = new OpenInterfaceDto();
        openInterfaceDto.setInterfaceType(Integer.valueOf(OpenInterfaceTypeEnum.AGENT.getType()));
        openInterfaceDto.setMerchantId(agentId);
        openInterfaceDto.setAppkey(APP_KEY_AGENT_PREFIX + appKey);
        openInterfaceDto.setAppsecret(AppSecretUtil.getAppSecret());
        openInterfaceDto.setGmtCreate(new Date());
        openInterfaceDto.setGmtModified(new Date());
        return this.remoteMerchantService.saveOpenInterface(openInterfaceDto);
    }

    @Override
    public List<MerchantSimpleVO> findNoOpenInterface(String merchantName) {
        List noOpenInterface = this.remoteMerchantService.findNoOpenInterface(merchantName);
        return BeanUtils.copyList((List)noOpenInterface, MerchantSimpleVO.class);
    }

    @Override
    public OpenInterfaceDto checkedAppKey(String appKey, String appSecret) {
        return this.remoteMerchantService.checkedAppKey(appKey, appSecret);
    }

    @Override
    public Boolean updateMerchantVersion(String versionSign, Long id) {
        return this.remoteMerchantService.updateVersionSign(versionSign, id);
    }
}

