/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PopupWindowDto;
import com.qiho.center.api.enums.PopupWindowDeletedFailEnum;
import com.qiho.center.api.remoteservice.RemotePopupWindowService;
import com.qiho.manager.biz.service.PopupWindowService;
import com.qiho.manager.biz.vo.PopupWindowVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PopupWindowServiceImpl
implements PopupWindowService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PopupWindowServiceImpl.class);
    @Resource
    private RemotePopupWindowService remotePopupWindowService;

    @Override
    public Integer add(PopupWindowDto popupWindowDto) {
        return this.remotePopupWindowService.add(popupWindowDto);
    }

    @Override
    public Integer deleteList(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            LOGGER.warn("\u5f39\u7a97id\u96c6\u5408\u4e3a\u7a7a\uff1aids={}", ids);
            return PopupWindowDeletedFailEnum.IDS_IS_NULL.getCode();
        }
        List popupWindowDtoList = this.remotePopupWindowService.queryByIds(ids).getList();
        if (CollectionUtils.isEmpty((Collection)popupWindowDtoList)) {
            LOGGER.warn("\u6839\u636e\u5f39\u7a97id\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u7ed3\u679c\uff1aids={}", ids);
            return PopupWindowDeletedFailEnum.DATA_IS_NULL.getCode();
        }
        List idList = popupWindowDtoList.stream().filter(e -> Boolean.FALSE.equals(e.getPopupWindowStatus())).map(PopupWindowDto::getId).collect(Collectors.toList());
        if (popupWindowDtoList.size() != idList.size()) {
            LOGGER.warn("\u8981\u5220\u9664\u7684\u5f39\u7a97\u5217\u8868\u4e2d\u5305\u542b\u5f00\u542f\u72b6\u6001\u7684\u5f39\u7a97\uff1a{}", (Object)popupWindowDtoList);
            return PopupWindowDeletedFailEnum.POPUP_WINDOW_STATUS_ON.getCode();
        }
        return this.remotePopupWindowService.deleteList(idList);
    }

    @Override
    public Integer update(PopupWindowDto popupWindowDto) {
        if (popupWindowDto.getPopupWindowStatus().booleanValue()) {
            this.remotePopupWindowService.closeOnStatus();
        }
        return this.remotePopupWindowService.update(popupWindowDto);
    }

    @Override
    public List<PopupWindowVO> queryList() {
        List popupWindowDtoList = this.remotePopupWindowService.queryList().getList();
        ArrayList popupWindowVOList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)popupWindowDtoList)) {
            popupWindowDtoList.forEach(e -> popupWindowVOList.add(BeanUtils.copy((Object)e, PopupWindowVO.class)));
        }
        return popupWindowVOList;
    }
}

