/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.dto.homepage.TabItemDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.enums.ItemStatusEnum;
import com.qiho.center.api.enums.page.PageTypeEnum;
import com.qiho.center.api.params.TabItemParams;
import com.qiho.center.api.params.TabItemQueryParam;
import com.qiho.center.api.remoteservice.RemoteSkinService;
import com.qiho.center.api.remoteservice.homepage.RemoteTabItemService;
import com.qiho.center.api.remoteservice.page.RemotePageBackendService;
import com.qiho.manager.biz.params.QueryStyleParam;
import com.qiho.manager.biz.service.TabItemService;
import com.qiho.manager.biz.vo.StyleVO;
import com.qiho.manager.biz.vo.homepage.TabItemVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TabItemServiceImpl
implements TabItemService {
    private static final Logger LOG = LoggerFactory.getLogger(TabItemServiceImpl.class);
    @Resource
    private RemoteTabItemService remoteTabItemService;
    @Resource
    private RemoteSkinService remoteSkinService;
    @Resource
    private RemotePageBackendService remotePageBackendService;

    @Override
    public List<TabItemVO> queryHomePageTabItem(Long tabId) {
        TabItemQueryParam param = new TabItemQueryParam();
        param.setTabId(tabId);
        DubboResult result = this.remoteTabItemService.findTabItemList(param);
        if (!result.isSuccess()) {
            return Lists.newArrayList();
        }
        List list = (List)result.getResult();
        List voList = BeanUtils.copyList((List)list, TabItemVO.class);
        for (int i = 0; i < list.size(); ++i) {
            String styleConfig = ((TabItemDto)list.get(i)).getStyleConfig();
            if (!StringUtils.isNotBlank((String)styleConfig) || !this.isJSON(styleConfig).booleanValue()) continue;
            ((TabItemVO)voList.get(i)).setStyleConfig(JSONObject.fromObject((Object)styleConfig.replaceAll(" ", "")));
            JSONObject map = ((TabItemVO)voList.get(i)).getStyleConfig();
            ((TabItemVO)voList.get(i)).setStyleName(this.getStyleName((Map<String, Object>)map));
        }
        return voList;
    }

    private Boolean isJSON(String str) {
        try {
            JSONObject.fromObject((Object)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getStyleName(Map<String, Object> map) {
        Long styleId;
        Long styleType;
        try {
            styleType = Long.parseLong(map.get("styleType").toString());
            styleId = Long.parseLong(map.get("styleId").toString());
        }
        catch (Exception e) {
            return "";
        }
        if (styleType == 1L) {
            SkinDto skinDto = (SkinDto)this.remoteSkinService.querySkinById(styleId).getResult();
            return skinDto == null ? "" : skinDto.getSkinName();
        }
        if (styleType == 2L) {
            BaiqiPageDto baiqiPageDto = this.remotePageBackendService.findById(styleId);
            return baiqiPageDto == null ? "" : baiqiPageDto.getPageName();
        }
        return "";
    }

    @Override
    public Integer saveTabItemList(Long tabId, List<Long> itemIdList) {
        ArrayList list = Lists.newArrayList();
        itemIdList.stream().forEach(itemId -> {
            TabItemParams params = new TabItemParams();
            params.setTabId(tabId);
            params.setItemId(itemId);
            list.add(params);
        });
        DubboResult result = this.remoteTabItemService.saveTabItemList((List)list);
        if (!result.isSuccess()) {
            return 0;
        }
        return (Integer)result.getResult();
    }

    @Override
    public Integer deleteItem(List<Long> idlist) {
        DubboResult result = this.remoteTabItemService.deleteTabItemByIdList(idlist);
        if (!result.isSuccess()) {
            return 0;
        }
        return (Integer)result.getResult();
    }

    @Override
    public Integer updateTabItemTopInfo(Integer topStatus, List<Long> idList, Long tabId) {
        DubboResult result = this.remoteTabItemService.updateTabItemTopPayloadByList(idList, tabId, Boolean.valueOf(topStatus == 1));
        return (Integer)result.getResult();
    }

    @Override
    public void updateStatusBatch(List<Long> itemIdList, Long tabId, Integer status, Long gmtModifier) {
        this.remoteTabItemService.updateStatus(itemIdList, tabId, status, gmtModifier);
    }

    @Override
    public List<TabItemVO> checkStatusAndStock(List<Long> itemIdList) {
        TabItemQueryParam param = new TabItemQueryParam();
        param.setItemIds(itemIdList);
        DubboResult result = this.remoteTabItemService.findTabItemList(param);
        if (!result.isSuccess()) {
            return Lists.newArrayList();
        }
        List list = BeanUtils.copyList((List)((List)result.getResult()), TabItemVO.class);
        ArrayList<TabItemVO> voList = new ArrayList<TabItemVO>();
        for (TabItemVO vo : list) {
            if (vo.getStock() == 0L || !StringUtils.equals((String)vo.getItemStatus(), (String)ItemStatusEnum.STATUS_ON.getCode())) continue;
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public List<TabItemVO> queryTabItemByTabIdAndItemIds(List<Long> itemIdList, Long tabId) {
        List dtoList = this.remoteTabItemService.queryTabItemByTabIdAndItemIds(itemIdList, tabId);
        return BeanUtils.copyList((List)dtoList, TabItemVO.class);
    }

    @Override
    public StyleVO getStyle(QueryStyleParam param) {
        Long styleId;
        Long styleType;
        JSONObject styleConfig = param.getStyleConfig();
        if (!this.isJSON(styleConfig.toString()).booleanValue()) {
            return null;
        }
        try {
            styleType = Long.parseLong(styleConfig.get("styleType").toString());
            styleId = Long.parseLong(styleConfig.get("styleId").toString());
        }
        catch (Exception e) {
            return null;
        }
        StyleVO styleVO = new StyleVO();
        styleVO.setStyleConfig((JSON)styleConfig);
        if (styleType == 1L) {
            SkinDto skinDto = (SkinDto)this.remoteSkinService.querySkinById(styleId).getResult();
            if (null != skinDto) {
                styleVO.setStyleName(skinDto.getSkinName());
            }
        } else if (styleType == 2L) {
            BaiqiPageDto baiqiPageDto = this.remotePageBackendService.findById(styleId);
            if (null == baiqiPageDto) {
                styleVO.setStyleName(null);
            }
            if (baiqiPageDto.getPageType().intValue() == PageTypeEnum.ITEM_DETAIL.getValue() || baiqiPageDto.getPageType().intValue() == PageTypeEnum.COMPONENT_ITEM_DETAIL.getValue()) {
                styleVO.setStyleName(baiqiPageDto.getPageName());
            } else if (baiqiPageDto.getPageType().intValue() == PageTypeEnum.ITEM_COLLECTION.getValue() || baiqiPageDto.getPageType().intValue() == PageTypeEnum.COMPONENT_COLLECTION_PAGE.getValue()) {
                styleVO.setStyleName(null);
            }
        }
        return styleVO;
    }

    @Override
    public Integer saveStyle(QueryStyleParam param) {
        JSONObject styleConfigJson = param.getStyleConfig();
        if (!this.isJSON(styleConfigJson.toString()).booleanValue()) {
            return null;
        }
        String styleConfig = styleConfigJson.toString();
        if (StringUtils.equals((String)"0", (String)styleConfigJson.get("styleType").toString())) {
            styleConfig = "";
        }
        TabItemParams tabItemParams = new TabItemParams();
        tabItemParams.setItemId(param.getItemId());
        tabItemParams.setTabId(param.getTabId());
        tabItemParams.setStyleConfig(styleConfig);
        return (Integer)this.remoteTabItemService.saveTabItem(tabItemParams).getResult();
    }

    @Override
    public Integer initTabItemStatus() {
        return (Integer)this.remoteTabItemService.initTabItemStatus().getResult();
    }
}

