/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl.blacklist;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BlackListStrategyDto;
import com.qiho.center.api.dto.bklist.StrategyDto;
import com.qiho.center.api.enums.blacklist.BlackListUseTypeEnum;
import com.qiho.center.api.remoteservice.blackList.RemoteBlackListStrategrService;
import com.qiho.manager.biz.service.blacklist.BlackListStrategyService;
import com.qiho.manager.biz.vo.blackList.BlackListStrategyVO;
import com.qiho.manager.biz.vo.merchant.SimpleMerchantVO;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlackListStrategyServiceImpl
implements BlackListStrategyService {
    @Autowired
    private RemoteBlackListStrategrService remoteBlackListStrategrService;

    @Override
    public BlackListStrategyVO findById(Long id) {
        if (null == id || (long)id.intValue() <= 0L) {
            return null;
        }
        BlackListStrategyDto blackListStrategyDto = this.remoteBlackListStrategrService.findById(id);
        if (null == blackListStrategyDto) {
            return null;
        }
        return this.convertBlackListStrategyToVO(blackListStrategyDto);
    }

    @Override
    public List<BlackListStrategyVO> queryBlackListStrategy(Long merchantId) {
        List blackListStrategyDtoList;
        if (null == merchantId || merchantId < 0L) {
            merchantId = -1L;
        }
        if (CollectionUtils.isEmpty((Collection)(blackListStrategyDtoList = this.remoteBlackListStrategrService.listByMerchantId(merchantId)))) {
            return Lists.newArrayList();
        }
        return blackListStrategyDtoList.stream().map(this::convertBlackListStrategyToVO).collect(Collectors.toList());
    }

    @Override
    public Boolean deleteBlackListStrategy(Long id) {
        if (null == id || (long)id.intValue() <= 0L) {
            throw new QihoManagerException("\u7b56\u7565id\u4e0d\u5408\u6cd5");
        }
        ResultDto resultDto = this.remoteBlackListStrategrService.deleteBlackListStrategy(id, RequestTool.getAdmin().getName());
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean saveBlackListStrategy(BlackListStrategyDto param) {
        if (param.getUseType() == BlackListUseTypeEnum.PART && CollectionUtils.isEmpty((Collection)param.getMerchantIdList())) {
            throw new QihoManagerException("\u5546\u5bb6id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ResultDto resultDto = param.getId() == null ? this.remoteBlackListStrategrService.createBlackListStrategy(param) : this.remoteBlackListStrategrService.updateBlackListStrategy(param);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return Boolean.TRUE;
    }

    private BlackListStrategyVO convertBlackListStrategyToVO(BlackListStrategyDto dto) {
        BlackListStrategyVO vo = (BlackListStrategyVO)BeanUtils.copy((Object)dto, BlackListStrategyVO.class);
        vo.setUseType(dto.getUseType().getNum());
        vo.setDealType(dto.getDealType().getNum());
        StrategyDto strategyDto = dto.getStrategy();
        vo.setStartDay(strategyDto.getStartDay());
        vo.setEndDay(strategyDto.getEndDay());
        vo.setSuccessRate(strategyDto.getSuccessRate());
        vo.setOrderCount(strategyDto.getOrderCount());
        if (CollectionUtils.isNotEmpty((Collection)dto.getMerchantList())) {
            vo.setMerchantList(BeanUtils.copyList((List)dto.getMerchantList(), SimpleMerchantVO.class));
        }
        return vo;
    }
}

