/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl.ordertmp;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.enums.ordertmp.OrderTmpStatusEnum;
import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;
import com.qiho.center.api.remoteservice.RemoteSkinService;
import com.qiho.center.api.remoteservice.ordertmp.RemoteOrderTmpService;
import com.qiho.center.api.remoteservice.page.RemotePageBackendService;
import com.qiho.manager.biz.runnable.OrderTmpExportRunnable;
import com.qiho.manager.biz.service.ordertmp.OrderTmpService;
import com.qiho.manager.biz.vo.ChannelInfoVO;
import com.qiho.manager.biz.vo.OrderDetailExtVo;
import com.qiho.manager.biz.vo.OrderItemVO;
import com.qiho.manager.biz.vo.OrderSkinVO;
import com.qiho.manager.biz.vo.OrderVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.ordertmp.OrderTmpDetailVO;
import com.qiho.manager.biz.vo.ordertmp.OrderTmpVO;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class OrderTmpServiceImpl
implements OrderTmpService,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderTmpServiceImpl.class);
    @Autowired
    private RemoteOrderTmpService remoteOrderTmpService;
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private ExecutorService executorService;
    @Resource
    private RemotePageBackendService remotePageBackendService;
    @Autowired
    private RemoteSkinService remoteSkinService;

    @Override
    public Pagenation<OrderTmpVO> queryOrderTmpPage(OrderTmpPageParam param) {
        Pagenation<OrderTmpVO> page = new Pagenation<OrderTmpVO>();
        PagenationDto pagenation = this.remoteOrderTmpService.queryOrderTmpPage(param);
        int count = pagenation.getTotal();
        page.setTotal(count);
        if (count == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        List orderTmpVOList = Lists.transform((List)pagenation.getList(), e -> {
            OrderTmpVO orderTmpVO = (OrderTmpVO)BeanUtils.copy((Object)e, OrderTmpVO.class);
            orderTmpVO.setOrderStatus(e.getOrderStatusEnum().getDesc());
            orderTmpVO.setGmtCreate(DateUtils.getSecondStr((Date)e.getGmtCreate()));
            return orderTmpVO;
        });
        page.setList(orderTmpVOList);
        return page;
    }

    @Override
    public boolean toValid(String orderId) {
        ResultDto resultDto = this.remoteOrderTmpService.toValid(orderId);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return true;
    }

    @Override
    public Map<String, Object> submitOrderExport(OrderTmpPageParam param) {
        OrderTmpExportRunnable runnable = (OrderTmpExportRunnable)this.applicationContext.getBean(OrderTmpExportRunnable.class);
        runnable.setPageParam(param);
        Map<String, Object> info = runnable.init();
        this.executorService.submit(runnable);
        int count = this.remoteOrderTmpService.countPageQuery(param);
        if (count <= 0) {
            throw new QihoManagerException("\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55");
        }
        info.put("count", count);
        return info;
    }

    @Override
    public OrderTmpDetailVO getDetail(String orderId) {
        OrderTmpDetailDto orderTmpDetailDto = this.remoteOrderTmpService.findByOrderId(orderId);
        if (null == orderTmpDetailDto) {
            throw new QihoManagerException("\u4e34\u65f6\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OrderTmpDetailVO orderTmpDetailVO = new OrderTmpDetailVO();
        OrderVO order = (OrderVO)BeanUtils.copy((Object)orderTmpDetailDto, OrderVO.class);
        order.setOrderStatus(OrderTmpStatusEnum.getByNum((int)orderTmpDetailDto.getOrderStatus()).getDesc());
        order.setGmtCreate(DateUtils.getSecondStr((Date)orderTmpDetailDto.getGmtCreate()));
        order.setGmtModified(DateUtils.getSecondStr((Date)orderTmpDetailDto.getGmtModified()));
        order.setDelivery(orderTmpDetailDto.getDeliveryEnum().getDesc());
        orderTmpDetailVO.setOrder(order);
        OrderItemVO orderItemVO = (OrderItemVO)BeanUtils.copy((Object)orderTmpDetailDto, OrderItemVO.class);
        orderItemVO.setCostPrice(orderTmpDetailDto.getItemCost());
        orderTmpDetailVO.setOrderItem(orderItemVO);
        ChannelInfoVO channelInfoVO = (ChannelInfoVO)BeanUtils.copy((Object)orderTmpDetailDto, ChannelInfoVO.class);
        orderTmpDetailVO.setChannelInfo(channelInfoVO);
        OrderSkinVO skinVO = this.getSkinVO(orderTmpDetailDto.getUrl(), orderTmpDetailDto.getSkinId());
        orderTmpDetailVO.setSkinItem(skinVO);
        List anticheatRules = orderTmpDetailDto.getAnticheatRules();
        orderTmpDetailVO.setAnticheateList(anticheatRules);
        String jsonExt = orderTmpDetailDto.getExtJson();
        if (StringUtils.isNotBlank((CharSequence)jsonExt)) {
            try {
                orderTmpDetailVO.getOrder().setExt((OrderDetailExtVo)JSONObject.parseObject((String)jsonExt, OrderDetailExtVo.class));
            }
            catch (Exception e) {
                LOGGER.info("\u89e3\u6790\u8ba2\u5355\u6269\u5c55\u4fe1\u606f\u9519\u8bef extjson={}", (Object)jsonExt, (Object)e);
            }
        }
        return orderTmpDetailVO;
    }

    private OrderSkinVO getSkinVO(String url, Long skinId) {
        OrderSkinVO skinItem = new OrderSkinVO();
        skinItem.setSkinId(skinId);
        if (url.contains("detail2")) {
            BaiqiPageDto pageDto = this.remotePageBackendService.findById(skinId);
            if (pageDto != null) {
                skinItem.setSkinName(pageDto.getPageName());
            }
        } else {
            try {
                DubboResult result = this.remoteSkinService.querySkinById(skinId);
                if (result.isSuccess() && result.getResult() != null) {
                    skinItem.setSkinName(((SkinDto)result.getResult()).getSkinName());
                }
            }
            catch (QihoManagerException e) {
                LOGGER.error("order detail get skin info error, skinId:{} ", (Object)skinId);
            }
        }
        return skinItem;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

