/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.logistics.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.dto.logistics.LogisticsNicknameDto;
import com.qiho.center.api.params.logitics.LogisticsQueryParam;
import com.qiho.center.api.remoteservice.logistics.RemoteLogisticsService;
import com.qiho.manager.biz.service.logistics.LogisticsService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.logistics.LogisticsNicknameVO;
import com.qiho.manager.biz.vo.logistics.LogisticsVO;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

@Service(value="logisticsService")
public class LogisticsServiceImpl
implements LogisticsService {
    @Resource
    private RemoteLogisticsService remoteLogisticsService;
    private static final String BAIQILOGISTICSLOCALMAPCACHEKEY = "baiqiLogisticsLocalMapCacheKey";
    private static final Cache<String, Map<String, String>> baiqiLogisticsLocalMapCache = CacheBuilder.newBuilder().maximumSize(5L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    @Override
    public List<LogisticsDto> findAll() {
        return this.remoteLogisticsService.findAll();
    }

    @Override
    public Pagenation<LogisticsVO> querypage(LogisticsQueryParam param) {
        PagenationDto pagenationDto = this.remoteLogisticsService.queryPage(param);
        Pagenation<LogisticsVO> page = new Pagenation<LogisticsVO>();
        page.setTotal(pagenationDto.getTotal());
        page.setList(BeanUtils.copyList((List)pagenationDto.getList(), LogisticsVO.class));
        return page;
    }

    @Override
    public List<LogisticsNicknameVO> findNickname(Long logisticsId) {
        return BeanUtils.copyList((List)this.remoteLogisticsService.findNickname(logisticsId), LogisticsNicknameVO.class);
    }

    @Override
    public Boolean addNickname(Long logisticsId, String nickname) {
        LogisticsNicknameDto dto = new LogisticsNicknameDto();
        dto.setLogisticsId(logisticsId);
        dto.setNickname(nickname);
        try {
            return this.remoteLogisticsService.addNickname(dto);
        }
        catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
    }

    @Override
    public Boolean deleteNickname(Long id) {
        try {
            return this.remoteLogisticsService.deleteNickname(id);
        }
        catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
    }

    @Override
    public String insertLogistics(String logisticsCode, String logisticsName) {
        LogisticsDto logisticsDto = new LogisticsDto();
        logisticsDto.setLogisticsCode(logisticsCode);
        logisticsDto.setLogisticsName(logisticsName);
        Boolean result = this.remoteLogisticsService.insertLogistics(logisticsDto);
        return "\u7269\u6d41\u516c\u53f8\u3010" + logisticsName + "\u3011\u63d2\u5165" + (result != false ? "\u6210\u529f" : "\u5931\u8d25");
    }

    @Override
    public String deleteLogistics(Long id) {
        Boolean result = this.remoteLogisticsService.deleteLogistics(id);
        return "\u7269\u6d41\u516c\u53f8id=" + id + "\u5220\u9664" + (result != false ? "\u6210\u529f" : "\u5931\u8d25");
    }

    @Override
    public Map<String, String> getBaiqiLogisticsCodeToName() {
        Map<String, String> map = (Map<String, String>)baiqiLogisticsLocalMapCache.getIfPresent((Object)BAIQILOGISTICSLOCALMAPCACHEKEY);
        if (MapUtils.isEmpty((Map)map)) {
            List logisticsDtos = this.remoteLogisticsService.findAll();
            map = logisticsDtos.stream().collect(Collectors.toMap(LogisticsDto::getLogisticsCode, LogisticsDto::getLogisticsName, (a, b) -> b));
            baiqiLogisticsLocalMapCache.put((Object)BAIQILOGISTICSLOCALMAPCACHEKEY, map);
        }
        return map;
    }
}

