/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.menu.impl;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.menu.MenuDto;
import com.qiho.center.api.params.menu.MenuParams;
import com.qiho.center.api.remoteservice.menu.RemoteMenuBackendService;
import com.qiho.manager.biz.service.menu.MenuService;
import com.qiho.manager.biz.vo.MenuVO;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="menuServiceImpl")
public class MenuServiceImpl
implements MenuService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MenuServiceImpl.class);
    @Resource
    private RemoteMenuBackendService remoteMenuBackendService;

    @Override
    public Boolean init() {
        return this.remoteMenuBackendService.initMenu();
    }

    @Override
    public Boolean save(MenuParams menuParams) {
        try {
            MenuDto menuDto = this.menuParamsToDto(menuParams);
            if (null == menuDto) {
                return Boolean.FALSE;
            }
            if (0L == this.remoteMenuBackendService.saveMenu(menuDto)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("\u83dc\u5355\u4fdd\u5b58\u9519\u8bef", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    @Override
    public MenuVO findByCode(String code) {
        MenuVO menuVO = new MenuVO();
        try {
            MenuParams menuParams = new MenuParams();
            menuParams.setMenuCode(code);
            List menuDtoList = this.remoteMenuBackendService.findByParam(menuParams);
            if (null == menuDtoList) {
                return menuVO;
            }
            return this.menuDtoToVO((MenuDto)menuDtoList.get(0));
        }
        catch (BizException e) {
            LOGGER.error("\u6839\u636e\u83dc\u5355Code\u67e5\u8be2", (Throwable)e);
            return menuVO;
        }
    }

    private MenuDto menuParamsToDto(MenuParams menuParams) {
        if (null == menuParams) {
            return null;
        }
        MenuDto menuDto = new MenuDto();
        menuDto.setParentId(menuParams.getParentId());
        menuDto.setMenuCode(menuParams.getMenuCode());
        menuDto.setMenuName(menuParams.getMenuName());
        menuDto.setRemark(menuParams.getRemark());
        menuDto.setSorted(menuParams.getSorted());
        return menuDto;
    }

    private MenuVO menuDtoToVO(MenuDto menuDto) {
        if (menuDto == null) {
            return null;
        }
        MenuVO menuVO = new MenuVO();
        menuVO.setId(menuDto.getId());
        menuVO.setParentId(menuDto.getParentId());
        menuVO.setMenuCode(menuDto.getMenuCode());
        menuVO.setMenuName(menuDto.getMenuName());
        menuVO.setRemark(menuDto.getRemark());
        menuVO.setSorted(menuDto.getSorted());
        menuVO.setDeleted(menuDto.getDeleted());
        menuVO.setGmtCreate(menuDto.getGmtCreate());
        menuVO.setGmtModified(menuDto.getGmtModified());
        return menuVO;
    }
}

