/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.message.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.message.MessageNotifyDto;
import com.qiho.center.api.params.message.MessageNotifyPagingParams;
import com.qiho.center.api.remoteservice.message.RemoteMessageBackendService;
import com.qiho.manager.biz.service.message.MessageNotifyService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.message.MessageNotifyVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MessageNotifyServiceImpl
implements MessageNotifyService {
    @Value(value="${message.edit.authority}")
    private String accounts;
    private static final String SPLITTER = ",";
    @Autowired
    private RemoteMessageBackendService remoteMessageService;

    @Override
    public Pagenation<MessageNotifyVO> queryMessageList(MessageNotifyPagingParams pagingParams) {
        Pagenation<MessageNotifyVO> pagenation = new Pagenation<MessageNotifyVO>();
        PagenationDto pagenationDto = this.remoteMessageService.findMessages(pagingParams);
        int total = pagenationDto.getTotal();
        List list = pagenationDto.getList();
        if (CollectionUtils.isEmpty((Collection)list) || total <= 0) {
            return pagenation;
        }
        pagenation.setList(this.ListTrans(list));
        pagenation.setTotal(total);
        return pagenation;
    }

    @Override
    public Boolean checkedUserAuthority() {
        String userAccount = RequestTool.getAdmin().getEmail();
        List<String> accountList = this.stringTOList();
        return accountList.contains(userAccount);
    }

    private List<String> stringTOList() {
        String[] accountList = this.accounts.split(SPLITTER);
        int len = accountList.length;
        ArrayList<String> list = new ArrayList<String>(len);
        for (String a : accountList) {
            if (list.contains(a)) continue;
            list.add(a);
        }
        return list;
    }

    private List<MessageNotifyVO> ListTrans(List<MessageNotifyDto> list) {
        ArrayList<MessageNotifyVO> pagenation = new ArrayList<MessageNotifyVO>();
        list.stream().forEach(item -> {
            MessageNotifyVO vo = (MessageNotifyVO)BeanUtils.copy((Object)item, MessageNotifyVO.class);
            vo.setGmtCreate(DateUtils.getSecondStr((Date)item.getGmtCreate()));
            pagenation.add(vo);
        });
        return pagenation;
    }
}

