/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.order.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.user.UserEvaluateDto;
import com.qiho.center.api.params.user.UserEvaluatePagingParams;
import com.qiho.center.api.remoteservice.user.RemoteUserEvaluateService;
import com.qiho.manager.biz.service.order.UserEvaluateService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.order.UserEvaluatePagingVO;
import com.qiho.manager.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class UserEvaluateServiceImpl
implements UserEvaluateService {
    @Resource
    private RemoteUserEvaluateService remoteUserEvaluateService;
    private String exportOpt = "EXPORT";

    @Override
    public Pagenation<UserEvaluatePagingVO> findPaging(UserEvaluatePagingParams pagingParam) {
        Pagenation<UserEvaluatePagingVO> pagenation = new Pagenation<UserEvaluatePagingVO>();
        PagenationDto pagenationDto = this.remoteUserEvaluateService.findPaing(pagingParam);
        List evaluateDtoList = pagenationDto.getList();
        int total = pagenationDto.getTotal();
        if (CollectionUtils.isEmpty((Collection)evaluateDtoList) || total <= 0) {
            return pagenation;
        }
        pagenation.setTotal(total);
        pagenation.setList(this.transVO(evaluateDtoList, "PAGING"));
        return pagenation;
    }

    private List<UserEvaluatePagingVO> transVO(List<UserEvaluateDto> evaluateDtoList, String optType) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)evaluateDtoList.size());
        evaluateDtoList.forEach(dto -> {
            UserEvaluatePagingVO pagingVO = (UserEvaluatePagingVO)BeanUtils.copy((Object)dto, UserEvaluatePagingVO.class);
            pagingVO.setGmtCreate(DateUtils.getSecondStr((Date)dto.getGmtCreate()));
            if (this.exportOpt.equals(optType)) {
                pagingVO.setEvaluateContent(StringUtil.removeFourChar((String)dto.getEvaluateContent()));
            }
            result.add(pagingVO);
        });
        return result;
    }

    @Override
    public List<UserEvaluatePagingVO> findExportList(UserEvaluatePagingParams pagingParam) {
        List evaluateDtoList = this.remoteUserEvaluateService.findEvaluateList(pagingParam);
        return this.transVO(evaluateDtoList, this.exportOpt);
    }
}

