/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.page.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.page.CollPageDto;
import com.qiho.center.api.enums.page.PageTypeEnum;
import com.qiho.center.api.remoteservice.page.RemoteCollPageBackendService;
import com.qiho.manager.biz.service.page.CollPageService;
import com.qiho.manager.biz.vo.page.CollPageVO;
import com.qiho.manager.biz.vo.page.CollSkinVO;
import com.qiho.manager.common.constant.DomainConstantUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="collPageService")
public class CollPageServiceImpl
implements CollPageService {
    @Resource
    private RemoteCollPageBackendService remoteCollPageBackendService;

    @Override
    public List<CollPageVO> queryList() {
        List collPageDtoList = this.remoteCollPageBackendService.queryList();
        if (CollectionUtils.isEmpty((Collection)collPageDtoList)) {
            return Lists.newArrayList();
        }
        int maxLen = 50;
        if (collPageDtoList.size() > maxLen) {
            collPageDtoList = collPageDtoList.subList(0, maxLen);
        }
        return this.transformCollPageVO(collPageDtoList);
    }

    @Override
    public List<CollPageVO> transformCollPageVO(List<CollPageDto> collPageDtoList) {
        return Lists.transform(collPageDtoList, collPageDto -> {
            CollPageVO collPageVO = (CollPageVO)BeanUtils.copy((Object)collPageDto, CollPageVO.class);
            collPageVO.setCollPageURL(DomainConstantUtil.getQihoWebUrl() + "/collection/index?collId=" + collPageDto.getId() + "&pid=" + collPageDto.getPageSkinId());
            return collPageVO;
        });
    }

    @Override
    public List<CollSkinVO> querySkinList() {
        List collectionSkinList = this.remoteCollPageBackendService.querySkinList(Integer.valueOf(PageTypeEnum.ITEM_COLLECTION.getValue()));
        List componentCollectionSkinList = this.remoteCollPageBackendService.querySkinList(Integer.valueOf(PageTypeEnum.COMPONENT_COLLECTION_PAGE.getValue()));
        if (CollectionUtils.isEmpty((Collection)collectionSkinList)) {
            collectionSkinList = Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty((Collection)componentCollectionSkinList)) {
            collectionSkinList.addAll(componentCollectionSkinList);
        }
        if (CollectionUtils.isEmpty((Collection)collectionSkinList)) {
            return Lists.newArrayList();
        }
        ArrayList collSkinVOList = Lists.newArrayList();
        collectionSkinList.forEach(baiqiPageDto -> {
            CollSkinVO collSkinVO = new CollSkinVO();
            collSkinVO.setId(baiqiPageDto.getId());
            collSkinVO.setLabel(baiqiPageDto.getPageName());
            collSkinVOList.add(collSkinVO);
        });
        CollSkinVO firstCollSkinVO = (CollSkinVO)collSkinVOList.get(0);
        List reverseList = Lists.reverse((List)collSkinVOList);
        reverseList.remove(reverseList.size() - 1);
        reverseList.add(0, firstCollSkinVO);
        return reverseList;
    }

    @Override
    public Integer saveCollPage(CollPageDto collPageDto) {
        Integer result = null == collPageDto.getId() || collPageDto.getId() <= 0L ? this.remoteCollPageBackendService.addCollPage(collPageDto) : this.remoteCollPageBackendService.updateCollPage(collPageDto);
        return result;
    }
}

