/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.page.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.dto.page.PageComponentDetailDto;
import com.qiho.center.api.enums.page.PageStatusEnum;
import com.qiho.center.api.enums.page.PageTypeEnum;
import com.qiho.center.api.enums.page.PageTypeReflectEnum;
import com.qiho.center.api.params.param.PagePagingParam;
import com.qiho.center.api.remoteservice.page.RemotePageBackendService;
import com.qiho.center.api.remoteservice.page.RemotePageComponentService;
import com.qiho.manager.biz.params.page.LandPageSaveParam;
import com.qiho.manager.biz.params.page.PageSaveParam;
import com.qiho.manager.biz.service.page.PageService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.page.PageEditVO;
import com.qiho.manager.biz.vo.page.PagePagingVO;
import com.qiho.manager.common.constant.DomainConstantUtil;
import com.qiho.manager.common.enums.DataPermissionEnum;
import com.qiho.manager.common.enums.ErrorCode;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pageService")
public class PageServiceImpl
implements PageService {
    private static final Logger logger = LoggerFactory.getLogger(PageServiceImpl.class);
    @Resource
    private RemotePageBackendService remotePageBackendService;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Value(value="${oss.objectPath}")
    private String ossYunUrl;
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;
    @Autowired
    private RemotePageComponentService remotePageComponentService;

    @Override
    public Pagenation<PagePagingVO> find4Paging(String pageName, List<Integer> pageTypes, String tabName, Integer offset, Integer pageSize) {
        PagenationDto pagenationDto;
        PagePagingParam pagePagingParam = this.buildQueryParam(pageName, pageTypes, tabName, offset, pageSize);
        try {
            pagenationDto = this.remotePageBackendService.find4Paging(pagePagingParam);
        }
        catch (Exception e) {
            throw new QihoManagerException("\u9875\u9762\u5206\u9875\u67e5\u8be2\u9519\u8bef", (Throwable)e);
        }
        Pagenation<PagePagingVO> result = new Pagenation<PagePagingVO>();
        int total = pagenationDto.getTotal();
        List pageDtoList = pagenationDto.getList();
        result.setTotal(total);
        result.setList(this.transDto2Vo(pageDtoList));
        return result;
    }

    private PagePagingParam buildQueryParam(String pageName, List<Integer> pageTypes, String tabName, Integer offset, Integer pageSize) {
        PagePagingParam pagePagingParam = new PagePagingParam();
        pagePagingParam.setPageName(pageName);
        pagePagingParam.setPageTypes(pageTypes);
        pagePagingParam.setPageSize(pageSize);
        pagePagingParam.setOffset(offset);
        boolean myLandPage = Objects.equals(tabName, PageTypeReflectEnum.MY_LAND_PAGE.getCode());
        if (myLandPage) {
            pagePagingParam.setOriginType(Integer.valueOf(PageTypeEnum.MY_LAND_PAGE.getValue()));
            pagePagingParam.setPageTypes(null);
        } else {
            pagePagingParam.setOriginType(Integer.valueOf(0));
        }
        String permissionCode = this.getPermissionCodeByTypes(pageTypes.get(0), false);
        this.buildCreateName(pagePagingParam, permissionCode);
        return pagePagingParam;
    }

    private void buildCreateName(PagePagingParam pagePagingParam, String permissionCode) {
        boolean hasThePermission = this.hasThePermission(permissionCode);
        if (!hasThePermission) {
            pagePagingParam.setCreateName(RequestTool.getAdmin().getName());
        }
    }

    private List<PagePagingVO> transDto2Vo(List<BaiqiPageDto> pageDtoList) {
        if (CollectionUtils.isEmpty(pageDtoList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)pageDtoList.size());
        pageDtoList.forEach(e -> {
            PagePagingVO pagingVO = (PagePagingVO)BeanUtils.copy((Object)e, PagePagingVO.class);
            pagingVO.setGmtCreate(DateUtils.getSecondStr((Date)e.getGmtCreate()));
            pagingVO.setGmtModified(DateUtils.getSecondStr((Date)e.getGmtModified()));
            result.add(pagingVO);
        });
        return result;
    }

    @Override
    public void savePage(String operatorName, PageSaveParam pageSaveParam) {
        Long pageId = pageSaveParam.getId();
        if (pageId != null && pageId > 0L) {
            this.checkPermission(pageId);
        }
        BaiqiPageDto pageDto = new BaiqiPageDto();
        if (pageSaveParam.getId() == null) {
            pageDto.setCreateName(operatorName);
        }
        pageDto.setOperatorName(operatorName);
        pageDto.setId(pageSaveParam.getId());
        pageDto.setPageType(Integer.valueOf(pageSaveParam.getPageType()));
        pageDto.setPageName(pageSaveParam.getPageName());
        pageDto.setPageImg(pageSaveParam.getPageImg());
        File tempFile = this.createFileFromCode(pageDto, pageSaveParam.getCode());
        this.upload2Oss(pageDto, tempFile, pageSaveParam.getPageType());
        this.doSave(pageDto);
        this.expireRedis(pageDto.getId());
    }

    public void checkPermission(Long pageId) {
        BaiqiPageDto baiqiPageDto = this.remotePageBackendService.findById(pageId);
        if (baiqiPageDto == null) {
            throw new QihoManagerException("\u66f4\u65b0\u7684\u9875\u9762\u4e0d\u5b58\u5728");
        }
        this.checkSsoPermission(pageId, this.getPermissionCodeByTypes(baiqiPageDto.getPageType(), true));
    }

    private void checkSsoPermission(Long pageId, String permissionCode) {
        BaiqiPageDto baiqiPageDto;
        boolean hasThePermission = this.hasThePermission(permissionCode);
        if (!(hasThePermission || (baiqiPageDto = this.remotePageBackendService.findById(pageId)) != null && baiqiPageDto.getCreateName().equals(RequestTool.getAdmin().getName()))) {
            throw new QihoManagerException(ErrorCode.NOT_ALLOWED.getMsg());
        }
    }

    private void expireRedis(Long pageId) {
        String key = "page:id:" + pageId;
        this.advancedCacheClient.remove(key);
    }

    @Override
    public PageEditVO findById(Long pageId) {
        BaiqiPageDto pageDto;
        if (pageId == null || pageId <= 0L) {
            return null;
        }
        try {
            pageDto = this.remotePageBackendService.findById(pageId);
        }
        catch (Exception e) {
            logger.error("id[{}]\u67e5\u8be2\u9875\u9762\u51fa\u9519", (Throwable)e);
            return null;
        }
        PageEditVO pageEditVO = (PageEditVO)BeanUtils.copy((Object)pageDto, PageEditVO.class);
        String code = this.fetchCodeFromUrl(pageDto.getPageUrl());
        pageEditVO.setCode(code);
        return pageEditVO;
    }

    private String fetchCodeFromUrl(String pageUrl) {
        String codes = (String)this.advancedCacheClient.get(pageUrl);
        if (StringUtils.isBlank((CharSequence)codes)) {
            try {
                URL url = new URL(pageUrl);
                CharSource charset = Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8);
                ImmutableList lines = charset.readLines();
                codes = Joiner.on((String)"").join((Iterable)lines);
                this.advancedCacheClient.set(pageUrl, (Object)codes, 5, TimeUnit.MINUTES);
                return codes;
            }
            catch (IOException e) {
                logger.error("\u4ece\u5730\u5740[{}]\u89e3\u6790\u4ee3\u7801\u51fa\u9519", (Object)pageUrl, (Object)e);
            }
        }
        return codes;
    }

    private void doSave(BaiqiPageDto pageDto) {
        PageTypeEnum typeEnum = PageTypeEnum.findByValue((int)pageDto.getPageType());
        switch (typeEnum) {
            case ITEM_DETAIL: {
                pageDto.setPageStatus(Integer.valueOf(PageStatusEnum.VALID.getValue()));
                break;
            }
        }
        try {
            Long pageId = this.remotePageBackendService.savePage(pageDto);
            pageDto.setId(pageId);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u9875\u9762\u51fa\u9519", (Throwable)e);
        }
    }

    private void upload2Oss(BaiqiPageDto pageDto, File tempFile, int pageType) {
        Boolean result;
        if (tempFile == null) {
            return;
        }
        String path = "pages";
        PageTypeEnum typeEnum = PageTypeEnum.findByValue((int)pageType);
        if (typeEnum != null) {
            path = path + "/" + typeEnum.toString();
        }
        if (!(result = Boolean.valueOf(UploadTool.uploadOssHtml((File)tempFile, (String)(path = path + "/" + tempFile.getName())))).booleanValue()) {
            throw new QihoManagerException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        pageDto.setPageUrl("http:" + this.ossYunUrl + path);
    }

    private File createFileFromCode(BaiqiPageDto pageDto, String code) {
        Long pageId = pageDto.getId();
        String fileName = RandomStringUtils.randomAlphabetic((int)6);
        String decodeCode = new String(SecurityUtils.decodeBase64((String)code));
        try {
            String pageMd5;
            File file = File.createTempFile(fileName, ".html");
            CharSink charSink = Files.asCharSink((File)file, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            charSink.write((CharSequence)decodeCode);
            String md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(file));
            pageDto.setPageMd5(md5);
            if (pageId != null && StringUtils.equals((CharSequence)(pageMd5 = this.remotePageBackendService.findPageMd5(pageId)), (CharSequence)md5)) {
                return null;
            }
            return file;
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Pagenation<PagePagingVO> findByPageId(Long pageId, List<Integer> pageTypes) {
        BaiqiPageDto pageDto;
        if (pageId == null || pageId <= 0L) {
            return null;
        }
        try {
            pageDto = this.remotePageBackendService.findById(pageId);
        }
        catch (Exception e) {
            logger.error("pageId[{}]\u67e5\u8be2\u9875\u9762\u51fa\u9519", (Object)pageId, (Object)e);
            return null;
        }
        if (null == pageDto) {
            return null;
        }
        if (!pageTypes.contains(pageDto.getPageType())) {
            return null;
        }
        boolean owner = RequestTool.getAdmin().getName().equals(pageDto.getCreateName());
        if (!owner && !this.hasThePermission(this.getPermissionCodeByTypes(pageTypes.get(0), true))) {
            return null;
        }
        ArrayList<PagePagingVO> pagePagingVOList = new ArrayList<PagePagingVO>();
        pagePagingVOList.add(this.convertVO(pageDto));
        Pagenation<PagePagingVO> pagePagingVOPagenation = new Pagenation<PagePagingVO>();
        pagePagingVOPagenation.setTotal(1);
        pagePagingVOPagenation.setList(pagePagingVOList);
        return pagePagingVOPagenation;
    }

    @Override
    @Transactional
    public boolean saveLandPage(LandPageSaveParam landPageSaveParam) {
        Integer pageType;
        Long pageId = landPageSaveParam.getPageId();
        Long itemId = landPageSaveParam.getItemId();
        BaiqiPageDto baiqiPageDto = this.remotePageBackendService.findById(pageId);
        if (baiqiPageDto == null || (pageType = baiqiPageDto.getPageType()) == null) {
            throw new QihoManagerException("\u9875\u9762Id\u9519\u8bef");
        }
        Long newPageId = pageType.intValue() == PageTypeEnum.COMPONENT_ITEM_DETAIL.getValue() || pageType.intValue() == PageTypeEnum.COMPONENT_COLLECTION_PAGE.getValue() ? this.copyComponent(landPageSaveParam.getPageId(), baiqiPageDto.getPageName()) : this.copyPage(baiqiPageDto);
        BaiqiPageDto param = new BaiqiPageDto();
        param.setId(newPageId);
        param.setPageType(pageType);
        param.setPageName(baiqiPageDto.getPageName());
        param.setLandPageUrl(this.renderGoods(newPageId, itemId));
        this.remotePageBackendService.savePage(param);
        return true;
    }

    private Long copyPage(BaiqiPageDto baiqiPageDto) {
        baiqiPageDto.setId(null);
        baiqiPageDto.setOriginType(Integer.valueOf(PageTypeEnum.MY_LAND_PAGE.getValue()));
        baiqiPageDto.setPageType(baiqiPageDto.getPageType());
        baiqiPageDto.setOperatorName(RequestTool.getAdmin().getName());
        baiqiPageDto.setCreateName(RequestTool.getAdmin().getName());
        return this.remotePageBackendService.savePage(baiqiPageDto);
    }

    private Long copyComponent(Long pageId, String pageName) {
        ResultDto resultDto;
        PageComponentDetailDto pageComponentDetail = this.remotePageComponentService.findPageComponentById(pageId);
        if (pageComponentDetail == null) {
            throw new QihoManagerException("\u9875\u9762\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        BaiqiPageDto pageDto = (BaiqiPageDto)BeanUtils.copy((Object)pageComponentDetail, BaiqiPageDto.class);
        pageDto.setId(null);
        pageDto.setPageName(pageName);
        pageDto.setOperatorName(RequestTool.getAdmin().getName());
        pageDto.setOriginType(Integer.valueOf(PageTypeEnum.MY_LAND_PAGE.getValue()));
        pageDto.setPageType(pageDto.getPageType());
        pageDto.setOperatorName(RequestTool.getAdmin().getName());
        pageDto.setCreateName(RequestTool.getAdmin().getName());
        List pageFormList = this.remotePageComponentService.findPageFormById(pageId);
        if (CollectionUtils.isNotEmpty((Collection)pageFormList)) {
            pageDto.setStrategyTypeList(pageFormList);
        }
        if (!(resultDto = this.remotePageComponentService.savePageComponent(pageDto, pageComponentDetail.getComponentList())).isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return (Long)resultDto.getResult();
    }

    private String renderGoods(Long newPageId, Long itemId) {
        if (newPageId == null || newPageId <= 0L) {
            throw new QihoManagerException("\u9875\u9762id\u9519\u8bef");
        }
        if (itemId == null || itemId <= 0L) {
            throw new QihoManagerException("\u5546\u54c1id\u9519\u8bef");
        }
        String host = DomainConstantUtil.getQihoWebUrl();
        return host + "/item/detail2?id=" + itemId + "&pid=" + newPageId;
    }

    private PagePagingVO convertVO(BaiqiPageDto pageDto) {
        PagePagingVO pagePagingVO = (PagePagingVO)BeanUtils.copy((Object)pageDto, PagePagingVO.class);
        pagePagingVO.setGmtCreate(DateUtils.getSecondStr((Date)pageDto.getGmtCreate()));
        pagePagingVO.setGmtModified(DateUtils.getSecondStr((Date)pageDto.getGmtModified()));
        return pagePagingVO;
    }

    private boolean hasThePermission(String code) {
        AdminDto admin = RequestTool.getAdmin();
        if (admin == null) {
            throw new QihoManagerException(ErrorCode.BAD_REQUEST.getMsg());
        }
        return this.adminPowerCacheService.hasPower(admin.getId(), code);
    }

    private String getPermissionCodeByTypes(Integer pageType, boolean edit) {
        boolean isCollection;
        if (pageType == null) {
            return "";
        }
        if (pageType.intValue() == PageTypeEnum.MY_LAND_PAGE.getValue()) {
            return DataPermissionEnum.MY_LAND_PAGE_ALL.getCode();
        }
        boolean bl = isCollection = pageType.intValue() == PageTypeEnum.COMPONENT_COLLECTION_PAGE.getValue() || pageType.intValue() == PageTypeEnum.ITEM_COLLECTION.getValue();
        if (isCollection) {
            return edit ? DataPermissionEnum.COLLECTION_EDIT_ALL.getCode() : DataPermissionEnum.COLLECTION_SEARCH_ALL.getCode();
        }
        return "";
    }
}

