/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.template.impl;

import cn.com.duiba.message.service.api.dto.SmsSignDto;
import cn.com.duiba.message.service.api.dto.SmsTemplateDto;
import cn.com.duiba.message.service.api.remoteservice.RemoteSmsBackedService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.qiho.center.api.dto.TemplateDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.params.template.TemplateParams;
import com.qiho.center.api.remoteservice.RemoteTemplateService;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantService;
import com.qiho.manager.biz.service.template.TemplateService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.TemplateVO;
import com.qiho.manager.common.enums.ErrorCode;
import com.qiho.manager.common.enums.RedisKeyEnum;
import com.qiho.manager.common.enums.RelatedMerchantIdsEnum;
import com.qiho.manager.common.enums.SmsTemplateEnumExt;
import com.qiho.manager.common.enums.TemplateBindType;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.param.TemplatePageParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger logger = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Autowired
    private RemoteMerchantService remoteMerchantService;
    @Autowired
    private RemoteTemplateService remoteTemplateService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private RemoteSmsBackedService remoteSmsBackedService;
    private static final String JOINER = ",";
    private static final String JOINER_SENSITIVE = ";";
    private static final String ALL_TEMPLATE = "-1";

    @Override
    public Pagenation<TemplateVO> findTemplateByParam(TemplatePageParam templatePageParam) {
        List listByName;
        if (templatePageParam == null) {
            throw new IllegalArgumentException("Param can not be null");
        }
        String merchantIds = null;
        String merchantName = templatePageParam.getMerchantName();
        String templateName = templatePageParam.getTemplateName();
        String appId = StringUtils.remove((String)templatePageParam.getAppId(), (String)" ");
        if (!StringUtils.isBlank((CharSequence)merchantName) && !CollectionUtils.isEmpty((Collection)(listByName = this.remoteMerchantService.findListByName(merchantName)))) {
            List ids = listByName.stream().map(MerchantDto::getId).map(String::valueOf).collect(Collectors.toList());
            merchantIds = String.join((CharSequence)JOINER, ids);
        }
        TemplateParams params = TemplateParams.builder().relatedMerchantIds(merchantIds).templateName(templateName).relatedAppIds(appId).build();
        List list = this.remoteTemplateService.findTemplateByParam(params);
        list.forEach(e -> e.setSmsType(SmsTypeEnum.fromCode((String)e.getSmsType()) == null ? null : SmsTypeEnum.fromCode((String)e.getSmsType()).getMsg()));
        Pagenation<TemplateVO> result = new Pagenation<TemplateVO>();
        List templateVOS = BeanUtils.copyList((List)list, TemplateVO.class);
        if (CollectionUtils.isEmpty((Collection)templateVOS)) {
            return result.emptyPage();
        }
        templateVOS.forEach(template -> {
            template.setAllBindSupport(SmsTemplateEnumExt.getBindSupport((String)template.getTemplateCode()));
            template.setAppBindSupport(SmsTemplateEnumExt.getAppBindSupport((String)template.getTemplateCode()));
            template.setBindType(this.queryTemplateBindType((TemplateVO)template));
        });
        Integer pageNum = templatePageParam.getPageNum();
        pageNum = pageNum == null ? 1 : pageNum;
        Integer pageSize = templatePageParam.getPageSize();
        pageSize = pageSize == null ? 20 : pageSize;
        int total = templateVOS.size();
        Integer start = pageNum <= 1 ? 0 : (pageNum - 1) * pageSize;
        Integer end = start + pageSize;
        if (end >= total) {
            end = total;
        }
        if (start > end && start > total) {
            start = 0;
        }
        result.setList(templateVOS.subList(start, end));
        result.setTotal(total);
        return result;
    }

    @Override
    public boolean addTemplate(TemplateParams templateParams) {
        this.checkSensitiveWord(templateParams);
        this.checkAppBindParam(templateParams);
        if (StringUtils.isBlank((CharSequence)templateParams.getRelatedAppIds())) {
            this.checkBindParam(templateParams);
        }
        this.checkPlatFormSmsCode(templateParams);
        if (SmsTypeEnum.YUNPIAN == SmsTypeEnum.fromCode((String)templateParams.getSmsType())) {
            templateParams.setNoteTemplateId("");
        }
        DubboResult result = this.remoteTemplateService.addTemplate(templateParams);
        return result.isSuccess();
    }

    private void checkPlatFormSmsCode(TemplateParams templateParams) {
        if (SmsTypeEnum.CENTRAL_PLATFORM_CODE != SmsTypeEnum.fromCode((String)templateParams.getSmsType())) {
            return;
        }
        Long modelId = templateParams.getModelId();
        Long signId = templateParams.getSignId();
        if (modelId == null || signId == null) {
            throw new QihoManagerException("\u4e2d\u53f0\u77ed\u4fe1\u6a21\u7248Id/\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SmsSignDto validSign = this.remoteSmsBackedService.getValidSign(signId);
        if (validSign == null) {
            throw new QihoManagerException("\u5f53\u524d\u77ed\u4fe1\u7b7e\u540dId: " + signId + " \u65e0\u6548");
        }
        SmsTemplateDto validTemplate = this.remoteSmsBackedService.getValidTemplate(modelId);
        if (validTemplate == null) {
            throw new QihoManagerException("\u5f53\u524d\u77ed\u4fe1\u6a21\u677fId: " + modelId + " \u65e0\u6548");
        }
        String templateCode = this.remoteTemplateService.getTemplateCodeById(templateParams.getId());
        boolean isSmsCode = SmsTemplateEnumExt.SMS_CODE.getCode().equals(templateCode);
        boolean isForgetPwd = SmsTemplateEnumExt.FORGET_PWD.getCode().equals(templateCode);
        boolean isUpdatePwd = SmsTemplateEnumExt.UPDATE_PWD.getCode().equals(templateCode);
        if (!(isSmsCode || isForgetPwd || isUpdatePwd)) {
            throw new QihoManagerException("\u5f53\u524d\u77ed\u4fe1\u6a21\u677f\u4ee3\u7801: " + templateCode + " \u4e0d\u5141\u8bb8\u7ed1\u5b9a\u8be5\u8fd0\u8425\u5546: " + SmsTypeEnum.CENTRAL_PLATFORM_CODE.getMsg());
        }
    }

    @Override
    public boolean updateTemplate(TemplateParams templateParams) {
        this.checkSensitiveWord(templateParams);
        this.checkAppBindParam(templateParams);
        if (StringUtils.isBlank((CharSequence)templateParams.getRelatedAppIds())) {
            this.checkBindParam(templateParams);
        }
        this.checkPlatFormSmsCode(templateParams);
        return this.remoteTemplateService.updateTemplate((TemplateParams)BeanUtils.copy((Object)templateParams, TemplateParams.class)).isSuccess();
    }

    private void checkSensitiveWord(TemplateParams templateParams) {
        String sensitiveWord = (String)this.redisTemplate.opsForValue().get((Object)RedisKeyEnum.SENSITIVIE_WORD_KEY.getFinalKey());
        if (StringUtils.isEmpty((CharSequence)sensitiveWord)) {
            return;
        }
        String templateContext = templateParams.getTemplateContext();
        String[] sensitiveWords = sensitiveWord.split(JOINER_SENSITIVE);
        ArrayList<String> hitMessage = new ArrayList<String>();
        for (String word : sensitiveWords) {
            if (!templateContext.contains(word)) continue;
            hitMessage.add(word);
        }
        if (hitMessage.isEmpty()) {
            return;
        }
        String errorMsg = "\u5f53\u524d\u6a21\u7248\u4e2d \"" + StringUtils.join(hitMessage, (String)"\u3001") + "\" \u4e3a\u7981\u7528\u8bcd\u6c47\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58";
        throw new QihoManagerException(errorMsg);
    }

    private void checkBindParam(TemplateParams templateParams) {
        if (templateParams == null) {
            throw new IllegalArgumentException("Param can not be null");
        }
        String relatedMerchantIds = templateParams.getRelatedMerchantIds();
        String templateCode = templateParams.getTemplateCode();
        Long id = templateParams.getId();
        if (id != null) {
            templateCode = this.remoteTemplateService.getTemplateCodeById(templateParams.getId());
        }
        if (!SmsTemplateEnumExt.bindSupport((String)templateCode) && !Objects.equals(relatedMerchantIds, ALL_TEMPLATE)) {
            throw new QihoManagerException(ErrorCode.NOT_ALLOWED.getMsg());
        }
        TemplateParams params = TemplateParams.builder().relatedMerchantIds(relatedMerchantIds).templateCode(templateCode).build();
        List templateDtoList = this.remoteTemplateService.findTemplateByParam(params);
        List dtoList = templateDtoList.stream().filter(templateDto -> !Objects.equals(id, templateDto.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dtoList)) {
            if (Objects.equals(relatedMerchantIds, ALL_TEMPLATE)) {
                throw new QihoManagerException(ErrorCode.REPEAT.getMsg());
            }
            throw new QihoManagerException(ErrorCode.ONLY_ONE.getMsg());
        }
    }

    private void checkAppBindParam(TemplateParams templateParams) {
        if (templateParams == null) {
            throw new IllegalArgumentException("Param can not be null");
        }
        if (StringUtils.isBlank((CharSequence)templateParams.getRelatedAppIds())) {
            return;
        }
        templateParams.setRelatedAppIds(StringUtils.remove((String)templateParams.getRelatedAppIds(), (String)" "));
        templateParams.setRelatedAppIds(StringUtils.removeEnd((String)templateParams.getRelatedAppIds(), (String)JOINER_SENSITIVE));
        String relatedAppIds = templateParams.getRelatedAppIds();
        String templateCode = templateParams.getTemplateCode();
        Long id = templateParams.getId();
        if (id != null) {
            templateCode = this.remoteTemplateService.getTemplateCodeById(templateParams.getId());
        }
        if (!SmsTemplateEnumExt.appBindSupport((String)templateCode)) {
            throw new QihoManagerException(ErrorCode.APP_NOT_ALLOWED.getMsg());
        }
        TemplateParams params = TemplateParams.builder().relatedAppIds(relatedAppIds).templateCode(templateCode).build();
        List templateDtoList = this.remoteTemplateService.findTemplateByParam(params);
        List<TemplateDto> dtoList = templateDtoList.stream().filter(templateDto -> !Objects.equals(id, templateDto.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dtoList)) {
            Set<String> existAppIds = this.findAppExist(dtoList, relatedAppIds);
            String errMsg = Joiner.on((String)"\u3001").appendTo(new StringBuilder("\u5a92\u4f53"), existAppIds).append("\u5df2\u5b58\u5728\u8ba2\u5355\u901a\u77e5\u6a21\u7248").toString();
            throw new QihoManagerException(errMsg);
        }
        templateParams.setRelatedMerchantIds(RelatedMerchantIdsEnum.APP.getType());
    }

    private Integer queryTemplateBindType(TemplateVO template) {
        if (StringUtils.isNotBlank((CharSequence)template.getRelatedAppIds())) {
            return TemplateBindType.APP.getType();
        }
        if (!CollectionUtils.isEmpty(template.getMerchantList())) {
            return TemplateBindType.MERCHANT.getType();
        }
        return TemplateBindType.TOTAL.getType();
    }

    private Set<String> findAppExist(List<TemplateDto> dtoList, String relatedAppIds) {
        Set<String> existAppIds = dtoList.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getRelatedAppIds())).flatMap(s -> Splitter.on((String)JOINER_SENSITIVE).omitEmptyStrings().trimResults().splitToList((CharSequence)s.getRelatedAppIds()).stream()).collect(Collectors.toSet());
        existAppIds.retainAll(Splitter.on((String)JOINER_SENSITIVE).omitEmptyStrings().trimResults().splitToList((CharSequence)relatedAppIds));
        return existAppIds;
    }
}

