package com.qiho.manager.common.constant;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;

import java.util.concurrent.TimeUnit;

/**
 * Created by liuyao on 2017/6/8.
 */
public enum CacheConstantseEnum {

    EXPORT_ORDER("EXPORT_ORDER_",10, TimeUnit.MINUTES),
    EXPORT_ORDER_CACEL("EXPORT_ORDER_CACEL_",1, TimeUnit.HOURS),
    DEAL_WITH_ORDER("DEAL_WITH_ORDER",10,TimeUnit.MINUTES),
    EXPORT_EXPRESS_BLACK_LIST("EXPORT_EXPRESS_BLACK_LIST_",10,TimeUnit.MINUTES),
    EXPORT_DISTRIBUTE_LOGISTICS_ORDER("EXPORT_DISTRIBUTE_LOGISTICS_ORDER_",1,TimeUnit.HOURS),
    EXPORT_MONITOR_REPORT("EXPORT_MONITOR_REPORT",10,TimeUnit.MINUTES),
    IMPORT_ITEM_EVALUATES("IMPORT_ITEM_EVALUATES",10,TimeUnit.MINUTES),

    /** 组件文件缓存 时效1天 */
    COMPONENT_FILE_URL("COMPONENT_FILE_URL", 1, TimeUnit.DAYS),

    /** 订单原始信息查看权限  时效1天 */
    ORDER_PRIMITIVE_AUTH_EMAIL("ORDER_PRIMITIVE_AUTH_EMAIL", 1, TimeUnit.DAYS),

    /** 商城首页商品老皮肤缓存 */
    ITEM_DETAIL_SKIN_ID("ITEM_DETAIL_SKIN_ID", 1, TimeUnit.MINUTES),
    /** 商城首页商品详情缓存 */
    ITEM_ID("ITEM_ID", 1, TimeUnit.MINUTES);


    private static final Joiner joiner = Joiner.on("").skipNulls();

    private String key;
    private Integer time;
    private TimeUnit timeUnit;

    CacheConstantseEnum(String key, Integer time, TimeUnit timeUnit) {
        this.key = key;
        this.time = time;
        this.timeUnit = timeUnit;
    }

    public String getCacheKey(Object bizId){
        return joiner.join(Lists.newArrayList(this.key,bizId));
    }

    public Integer getTime() {
        return time;
    }

    public TimeUnit getTimeUnit() {
        return timeUnit;
    }

}
