package com.qiho.manager.common.enums;

/**
 * 商品评论保存失败原因枚举类
 *
 * @author jiafeng.geng
 * @date 2018-9-5
 */
public enum ItemEvaluateSaveFailedEnum {
    EXCESS_MAX_THRESHOLD(-1, "EXCESS_MAX_THRESHOLD", "评价总数超过最大数量");

    private Integer code;
    private String type;
    private String desc;

    private ItemEvaluateSaveFailedEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static ItemEvaluateSaveFailedEnum getByCode(Integer code) {
        for (ItemEvaluateSaveFailedEnum enumVal : ItemEvaluateSaveFailedEnum.values()) {
            if (code.intValue() == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {

        return code;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
