package com.qiho.manager.common.param;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;

/**
 * 分页参数
 *
 * @author peanut.huang
 * @date 2018/6/7.
 */
public class PageParam {


    @ApiModelProperty("页码")
    @Min(value = 1, message = "页码，最小为1")
    private Integer pageNum;

    @ApiModelProperty(value = "每页条数")
    @Min(value = 1, message = "每页条数，最小为1")
    private Integer pageSize;

    /**
     * pageNum.
     *
     * @return the pageNum
     */
    public Integer getPageNum() {
        return pageNum;
    }

    /**
     * pageNum.
     *
     * @param pageNum the pageNum to set
     */
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * pageSize.
     *
     * @return the pageSize
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * pageSize.
     *
     * @param pageSize the pageSize to set
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }


}
