package com.qiho.manager.common.util;

import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestUtils {

    private static final Logger LOG = LoggerFactory.getLogger(MessageDigestUtils.class);

    private MessageDigestUtils(){
    }

    public static String toSHABase64(String str) {
        return messageDigest(str, "SHA");
    }

    public static String toMD5Base64(String str) {
        return messageDigest(str, "MD5");
    }

    private static String messageDigest(String str, String alg) {
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            md.update(str.getBytes("UTF-8"));
            Base64 bs = new Base64();
            return bs.encodeToString(md.digest());
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
            AppLogUtil.warn(LOG, "加密失败str={}", str, e);
        }
        return str;
    }
}
