package com.qiho.manager.common.util;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;

/**
 * @author jiafeng.geng
 * @date 2018-10-30.
 */
public class ReadResourceUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(ReadResourceUtil.class);

    private ReadResourceUtil() {
    }

    /**
     * 根据url地址读取资源
     *
     * @param url 文件地址
     * @return 数据资源的字符串形式
     */
    public static String readResource(String url) {
        if (StringUtils.isBlank(url)) {
            return StringUtils.EMPTY;
        }

        if (StringUtils.startsWith(url, "//")) {
            url = "http:" + url;
        }

        if (!StringUtils.startsWith(url,"http")) {
            url = "http://" + url;
        }

        try {
            List<String> lines = Resources.asCharSource(new URL(url), Charset.defaultCharset()).readLines();
            return Joiner.on("").join(lines);
        } catch (Exception e) {
            LOGGER.error("读取资源异常：url={}", url, e);
            return StringUtils.EMPTY;
        }
    }
}