/**
 * Project Name:activity-cms-web
 * File Name:SimpleStringFormat.java
 * Package Name:com.duiba.activity.cmsweb.tool
 * Date:2016年8月11日下午2:33:26
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.manager.common.util;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ClassName:SimpleStringFormat <br/>
 * 简单的字符串模板实现
 * 支持 {} 替代符
 * Date:     2016年8月11日 下午2:33:26 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class SimpleStringFormat {
    private static Logger    log = LoggerFactory.getLogger(SimpleStringFormat.class);

    private SimpleStringFormat(){
    }
    /**
     * 格式化String
     * 
     * @param template
     * @param args
     * @return formatString
     */
    public static String format(String template, Object... args) {
        String newTemplate = String.valueOf(template); // null -> "null"
        if (args == null || args.length == 0) {
            return template;
        }

        // start substituting the arguments into the '%s' placeholders
        StringBuilder builder = new StringBuilder(newTemplate.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length) {
            int placeholderStart = newTemplate.indexOf("{}", templateStart);
            if (placeholderStart == -1) {
                break;
            }
            builder.append(newTemplate.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(newTemplate.substring(templateStart));

        // if we run out of placeholders, append the extra args in square braces
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }

        return builder.toString();
    }
    
    /**
     * 转换参数对象为字符串
     * 
     * @param args 
     * @return String
     */
    public static String getArgsLogStr(Object[] args) {
        if (null == args) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < args.length; i++) {
            Object arg = args[i];
            try {
                buf.append(JSON.toJSONString(arg));
            }catch(Exception e){
                //Ignore
                AppLogUtil.error(log, "json parse error", e);
            }
            if (i != args.length - 1) {
                buf.append(",");
            }
        }
        buf.append("]");
        return buf.toString();
    }
    
}
