/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import com.qiho.manager.common.exception.QihoManagerException;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AssertUtil {
    private AssertUtil() {
    }

    public static void stringNotBlank(String value, String message) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new QihoManagerException(StringUtils.defaultString((String)message));
        }
    }

    public static void objectNotNull(Object obj, String message) {
        if (Objects.equals(obj, null)) {
            throw new QihoManagerException(StringUtils.defaultString((String)message));
        }
    }

    public static void collectionNotEmpty(Collection<?> coll, String message) {
        if (CollectionUtils.isEmpty(coll)) {
            throw new QihoManagerException(StringUtils.defaultString((String)message));
        }
    }

    public static void numericIsPositive(Long value, String message) {
        if (value == null || value < 1L) {
            throw new QihoManagerException(StringUtils.defaultString((String)message));
        }
    }

    public static void numericIsPositive(Integer value, String message) {
        if (value == null || value < 1) {
            throw new QihoManagerException(StringUtils.defaultString((String)message));
        }
    }

    public static void collectionOnRange(Collection<?> coll, int min, int max, String message) {
        if (Objects.equals(coll, null)) {
            throw new IllegalArgumentException("validate collection is null");
        }
        if (min < 0) {
            throw new IllegalArgumentException("argument min=" + min + " is smaller than zero");
        }
        if (max < 0) {
            throw new IllegalArgumentException("argument max=" + max + " is smaller than zero");
        }
        if (min > max) {
            throw new IllegalArgumentException("argument min=" + min + " is bigger than max=" + max);
        }
        int size = coll.size();
        if (size < min || size > max) {
            throw new QihoManagerException(StringUtils.defaultString((String)message));
        }
    }
}

