/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Md5Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Md5Util.class);
    private static String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private Md5Util() {
    }

    public static String md5WithSalt(String data, String salt) {
        return Md5Util.md5(data + salt);
    }

    public static String md5(String data) {
        String md5Str = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] b = data.getBytes(Charset.forName("utf8"));
            md5.update(b, 0, b.length);
            md5Str = Md5Util.byteArrayToHexString(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("md5\u52a0\u5bc6\u5b57\u7b26\u4e32\u5931\u8d25", (Throwable)e);
        }
        return md5Str;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (byte aB : b) {
            sb.append(Md5Util.byteToHexString(aB));
        }
        return sb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
}

