/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import com.qiho.manager.common.util.AppLogUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDigestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDigestUtils.class);

    private MessageDigestUtils() {
    }

    public static String toSHABase64(String str) {
        return MessageDigestUtils.messageDigest(str, "SHA");
    }

    public static String toMD5Base64(String str) {
        return MessageDigestUtils.messageDigest(str, "MD5");
    }

    private static String messageDigest(String str, String alg) {
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            md.update(str.getBytes("UTF-8"));
            Base64 bs = new Base64();
            return bs.encodeToString(md.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            AppLogUtil.warn(LOG, "\u52a0\u5bc6\u5931\u8d25str={}", str, e);
            return str;
        }
    }
}

