/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import com.alibaba.fastjson.JSON;
import com.qiho.manager.common.util.AppLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStringFormat {
    private static Logger log = LoggerFactory.getLogger(SimpleStringFormat.class);

    private SimpleStringFormat() {
    }

    public static String format(String template, Object ... args) {
        int placeholderStart;
        String newTemplate = String.valueOf(template);
        if (args == null || args.length == 0) {
            return template;
        }
        StringBuilder builder = new StringBuilder(newTemplate.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = newTemplate.indexOf("{}", templateStart)) != -1) {
            builder.append(newTemplate.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(newTemplate.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static String getArgsLogStr(Object[] args) {
        if (null == args) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            try {
                buf.append(JSON.toJSONString((Object)arg));
            }
            catch (Exception e) {
                AppLogUtil.error(log, "json parse error", e);
            }
            if (i == args.length - 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }
}

