package com.qiho.manager.common.enums;

import java.util.Objects;

/**
 * @author Wangpf
 * @description 短信模板扩展类，增加allBindSupport字段来标识是否支持绑定部分商家
 * @date 2019/9/17 1:55 PM
 */
public enum SmsTemplateEnumExt {

    /**
     * 发送手机验证码短信，需要参数:1.手机验证码
     */
    SMS_CODE("SMS_CODE","手机验证码短信",0, 0),

    /**
     * 下单成功短信, 需要参数：1.商品简称, 2.订单详情短链
     */
    ORDER_SUCCESS("ORDER_SUCCESS","下单成功短信",1, 1),

    /**
     * 下单温馨提示短信
     */
    ORDER_NOTIFY("ORDER_NOTIFY","下单温馨提示短信",1, 0),

    /**
     * 订单发货提醒短信，需要参数：1.快递单号，2.订单详情短链
     */
    ORDER_SEND("ORDER_SEND","订单发货提醒短信",1, 0),

    /**
     * 订单派送短信
     */
    ORDER_DELIVERY("ORDER_DELIVERY","订单派送短信",1, 0),

    /**
     * 在线支付订单派送短信
     */
    ORDER_DELIVERY_PAID("DELIVERY_PAID","订单派送短信（已付款）",1, 0),

    /**
     * 快递100订单派送短信
     */
    ORDER_DELIVERY_100("ORDER_DELIVERY_1","快递100订单派送短信",1, 0),

    /**
     * 快递100在线支付订单派送短信
     */
    ORDER_DELIVERY_PAID_100("DELIVERY_PAID100","快递100订单派送短信（已付款）",1, 0),

    /**
     * 订单签收短信
     */
    ORDER_RECIVED("ORDER_RECIVED","订单签收短信",1, 0),

    /**
     * 支付提醒
     */
    PAY_REMIND("PAY_REMIND","订单支付提醒",1, 0),

    /**
     * 在线支付成功
     */
    PAY_SUCCESS("PAY_SUCCESS","订单在线支付成功",1, 0),

    /**
     * 短信捞单
     */
    NOTE_GAIN("NOTE_GAIN","短信捞单",1, 0),

    /**
     * 下单成功短信,包含400客服热线
     **/
    ORDER_SUCC_400("ORDER_SUCC_400","下单成功短信(400客服)",1, 1),

    /**
     * 物流监控短信模板
     **/
    MONITOR_REPORT("MONITOR_REPORT","物流监控短信通知",1, 0),

    /**
     * 忘记密码验证码
     */
    FORGET_PWD("FORGET_PWD","忘记密码验证码",0, 0),

    /**
     * 修改密码验证码
     */
    UPDATE_PWD("UPDATE_PWD","修改密码验证码",0, 0);

    /**
     * 代码
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 是否支持绑定部分商家 1-是 0-不是
     */
    private final int allBindSupport;

    /**
     * 是否支持绑定部分媒体 1-是 0-不是
     */
    private final int appBindSupport;

    SmsTemplateEnumExt(String code,String desc,int allBindSupport, int appBindSupport) {
        this.code = code;
        this.desc = desc;
        this.allBindSupport = allBindSupport;
        this.appBindSupport = appBindSupport;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public int getAllBindSupport() {
        return allBindSupport;
    }

    public int getAppBindSupport() {
        return appBindSupport;
    }

    /**
     * 判断当前状态码是否支持部分商家绑定
     *
     * @param code 模板代码
     * @return
     */
    public static boolean bindSupport(String code) {
        return getBindSupport(code) == 1;
    }

    /**
     * 获取当前模板代码绑定支持
     *
     * @param code 模板代码
     * @return
     */
    public static int getBindSupport(String code) {
        for (SmsTemplateEnumExt temp : SmsTemplateEnumExt.values()) {
            if (Objects.equals(code,temp.getCode())) {
                return temp.getAllBindSupport();
            }
        }
        return 0;
    }

    /**
     * 判断当前状态码是否支持部分媒体绑定
     *
     * @param code 模板代码
     * @return true.支持;false.不支持
     */
    public static boolean appBindSupport(String code) {
        return getAppBindSupport(code) == 1;
    }

    /**
     * 获取当前模板代码媒体绑定支持
     */
    public static int getAppBindSupport(String code) {
        for (SmsTemplateEnumExt temp : SmsTemplateEnumExt.values()) {
            if (Objects.equals(code, temp.getCode())) {
                return temp.getAppBindSupport();
            }
        }
        return 0;
    }
}
