package com.qiho.manager.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Created by sunchangji on 2017/12/8.
 */
public class Md5Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Md5Util.class);

    private Md5Util() {
    }

    private static String[] hexDigits = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    /**
     * 带盐对data进行加密
     *
     * @param data 加密值
     * @param salt 加密的盐
     * @return
     */
    public static String md5WithSalt(String data, String salt) {
        return md5(data + salt);

    }


    /**
     * md5加密
     *
     * @param data
     * @return
     */
    public static String md5(String data) {
        String md5Str = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] b = data.getBytes(Charset.forName("utf8"));
            md5.update(b, 0, b.length);
            md5Str = byteArrayToHexString(md5.digest());
        } catch (NoSuchAlgorithmException e) {
            LOGGER.error("md5加密字符串失败", e);
        }
        return md5Str;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (byte aB : b) {
            sb.append(byteToHexString(aB));
        }
        return sb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0)
            n = 256 + n;
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
}
