/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import com.qiho.manager.common.util.AppLogUtil;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbUtil.class);

    private JaxbUtil() {
    }

    public static String convertToXml(Object obj) {
        return JaxbUtil.convertToXml(obj, "UTF-8");
    }

    public static String convertToXml(Object obj, String encoding) {
        String result = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            marshaller.setProperty("jaxb.fragment", (Object)true);
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, (Writer)writer);
            result = writer.toString();
        }
        catch (Exception e) {
            AppLogUtil.error(LOG, "JavaBean\u8f6c\u6362\u6210xml\u5931\u8d25\uff0cobj={}", obj, e);
        }
        return result;
    }

    public static <T> T converyToJavaBean(String xml, Class<T> c) {
        Object t = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            t = unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            AppLogUtil.error(LOG, "xml\u8f6c\u6362\u6210JavaBean\u5931\u8d25\uff0cxml={}", xml, e);
        }
        return (T)t;
    }
}

