package com.qiho.manager.common.enums;

/**
 * @author Wangpf
 * @description 页面状态枚举类维护
 * @date 2020/3/13 11:10 AM
 */
public enum  DataPermissionEnum {

    /**
     * 我的落地页全局权限
     */
    MY_LAND_PAGE_ALL("myLandPageAll","我的落地页全局权限"),

    /**
     * 落地页模板权限
     */
    LAND_PAGE_MODEL_ALL("landPageModelAll","落地页模板权限"),

    /**
     * 集合页全局查看权限
     */
    COLLECTION_SEARCH_ALL("collectionSearchAll","集合页全局查看权限"),

    /**
     * 集合页全局编辑权限
     */
    COLLECTION_EDIT_ALL("collectionEditAll","集合页全局编辑权限")

    ;

    private final String code;


    private final String desc;

    DataPermissionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
