package com.qiho.manager.common.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/11/3.
 * 区分查询时间类型的枚举
 */
public enum TimeTypeEnum {

    START_TIME("START_TIME","开始时间"),
    END_TIME("END_TIME","结束时间");

    private String code;
    private String msg;

    TimeTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static TimeTypeEnum getByCode(String code) {
        for (TimeTypeEnum enumVal : TimeTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getMsg() {
        return msg;
    }

    public String getCode() {
        return code;
    }

}
