package com.qiho.manager.common.util;

import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Objects;

/**
 * 断言判定工具类
 *
 * @author chensong
 * @create 2018-08-06
 */
public class AssertUtil {


    private AssertUtil(){}

    /**
     * 断言字符串不为空
     *
     * @param value 校验的字符串
     * @param message 校验失败的异常信息
     */
    public static void stringNotBlank(String value, String message){
        if (StringUtils.isBlank(value)) {
            throw new QihoManagerException(StringUtils.defaultString(message));
        }
    }

    /**
     * 断言对象不为null
     * @param obj
     * @param message
     */
    public static void objectNotNull(Object obj, String message){
        if (Objects.equals(obj, null)) {
            throw new QihoManagerException(StringUtils.defaultString(message));
        }
    }

    /**
     * 断言集合不为空
     * @param coll
     * @param message
     */
    public static void collectionNotEmpty(Collection<?> coll, String message){
        if (CollectionUtils.isEmpty(coll)) {
            throw new QihoManagerException(StringUtils.defaultString(message));
        }
    }

    /**
     * 断言数值为正整数
     * @param value
     * @param message
     */
    public static void numericIsPositive(Long value, String message){
        if (value == null || value < 1L) {
            throw new QihoManagerException(StringUtils.defaultString(message));
        }
    }

    /**
     * 断言数值为正整数
     * @param value
     * @param message
     */
    public static void numericIsPositive(Integer value, String message){
        if (value == null || value < 1) {
            throw new QihoManagerException(StringUtils.defaultString(message));
        }
    }

    /**
     * 断言集合在给定范围内
     * @param coll 检验的集合对象
     * @param min 最小size
     * @param max 最大size
     * @param message 错误信息
     */
    public static void collectionOnRange(Collection<?> coll, int min, int max, String message){
        if (Objects.equals(coll, null)) {
            throw new IllegalArgumentException("validate collection is null");
        }
        if (min < 0){
            throw new IllegalArgumentException("argument min=" + min + " is smaller than zero");
        }
        if (max < 0){
            throw new IllegalArgumentException("argument max=" + max + " is smaller than zero");
        }
        if (min > max){
            throw new IllegalArgumentException("argument min=" + min + " is bigger than max=" + max);
        }
        int size = coll.size();
        if (size < min || size > max) {
            throw new QihoManagerException(StringUtils.defaultString(message));
        }
    }


}
