package com.qiho.manager.common.util;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by sunchangji on 2018/1/17.
 */
public class ExcelUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelUtil.class);

    private ExcelUtil(){

    }
    /**
     * 导出excel文件
     *
     * @param response
     * @param workbook
     */
    public static void exportExcel(HttpServletResponse response, Workbook workbook, String fileName) {
        response.reset();
        response.setContentType("application/x-msdownload");
        String fileNameTemp = fileName + new SimpleDateFormat("yyyyMMdd").format(new Date());
        try (ServletOutputStream outputStream = response.getOutputStream()) {
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileNameTemp.getBytes("gb2312"), "ISO-8859-1") + ".xlsx");
            workbook.write(outputStream);
        } catch (Exception e) {
            LOGGER.warn("导出excel出错", e);
        }
    }

    /**
     * 导出指定格式的excel文件
     *
     * @param response
     * @param workbook
     */
    public static void exportExcelByPostfix(HttpServletResponse response, Workbook workbook, String fileName,
        String postfix, Date startTime, Date endTime) {
        response.reset();
        response.setContentType("application/x-msdownload");
        response.setCharacterEncoding("utf-8");
        String startDate = new SimpleDateFormat("yyyy.MM.dd").format(startTime);
        String endDate = new SimpleDateFormat("yyyy.MM.dd").format(endTime);
        String fileNameTemp;
        if (StringUtils.equalsIgnoreCase(startDate,endDate)) {
            fileNameTemp = fileName + startDate;
        } else {
            fileNameTemp = fileName + startDate + "-" + endDate;
        }
        try (ServletOutputStream outputStream = response.getOutputStream()) {
            response.setHeader("Content-disposition",
                "attachment; filename=" + new String(fileNameTemp.getBytes("gb2312"), "ISO-8859-1") + postfix);
            workbook.write(outputStream);
        } catch (Exception e) {
            LOGGER.warn("导出excel出错", e);
        }
    }
}
