/**
 * Project Name:qiho-manager-common File Name:JaxbUtil.java Package Name:com.qiho.manager.common.util
 * Date:2017年5月16日下午12:10:28 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.io.StringWriter;

/**
 * ClassName:JaxbUtil <br/>
 * JAXB工具类 <br/>
 * Date: 2017年5月16日 下午12:10:28 <br/>
 * 
 * @author zhanglihui
 * @version
 * @see
 */
public class JaxbUtil {

    private static final Logger LOG = LoggerFactory.getLogger(JaxbUtil.class);

    private JaxbUtil(){
    }

    /**
     * JavaBean转换成xml 默认编码UTF-8
     * 
     * @param obj
     * @return xml
     */
    public static String convertToXml(Object obj) {
        return convertToXml(obj, "UTF-8");
    }

    /**
     * JavaBean转换成xml
     * 
     * @param obj
     * @param encoding
     * @return xml
     */
    public static String convertToXml(Object obj, String encoding) {
        String result = null;
        try {
            JAXBContext context = JAXBContext.newInstance(obj.getClass());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            marshaller.setProperty(Marshaller.JAXB_ENCODING, encoding);
            marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, writer);
            result = writer.toString();
        } catch (Exception e) {
            AppLogUtil.error(LOG, "JavaBean转换成xml失败，obj={}", obj, e);
        }
        return result;
    }

    /**
     * xml转换成JavaBean
     * 
     * @param xml
     * @param c
     * @return javaBean
     */
    @SuppressWarnings("unchecked")
    public static <T> T converyToJavaBean(String xml, Class<T> c) {
        T t = null;
        try {
            JAXBContext context = JAXBContext.newInstance(c);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            t = (T) unmarshaller.unmarshal(new StringReader(xml));
        } catch (Exception e) {
            AppLogUtil.error(LOG, "xml转换成JavaBean失败，xml={}", xml, e);
        }
        return t;
    }
}
