package com.qiho.manager.common.util;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/**
 * 验证工具类
 * <p>
 * Created by sunchangji on 2017/12/7.
 */
public class ValidateUtil {

    /**
     * 手机号正则
     */
    private static final String PHONE_REG = "^(13[0-9]|14[5-9]|15[0-9]|166|17[0-8]|18[0-9]|19[8,9])[0-9]{8}$";

    /**
     * 正则,字母和数组组合
     */
    private static final String ACCOUNT_REG = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{2,50}$";

    /**
     * 密码正则 6至50位字母和数字组合
     */
    private static final String PD_REG = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,50}$";

    private static Pattern phonePattern = Pattern.compile(PHONE_REG);
    private static Pattern pdPattern = Pattern.compile(PD_REG);
    private static Pattern accountPattern = Pattern.compile(ACCOUNT_REG);

    private ValidateUtil() {
    }

    /**
     * 密码验证
     *
     * @param password
     * @return
     */
    public static boolean validPassword(String password) {
        if (StringUtils.isBlank(password)) {
            return Boolean.FALSE;
        }
        return pdPattern.matcher(password).matches();
    }


    /**
     * 验证手机号是否合法
     *
     * @param phoneNum 手机号
     * @return true:合法,false:不合法
     */
    public static boolean validPhoneNum(String phoneNum) {
        if (StringUtils.isBlank(phoneNum)) {
            return Boolean.FALSE;
        }
        return phonePattern.matcher(phoneNum).matches();
    }

    /**
     * 验证账户是否合法
     *
     * @param account 账户
     * @return true:合法,false:不合法
     */
    public static boolean validAccount(String account) {
        if (StringUtils.isBlank(account)) {
            return Boolean.FALSE;
        }
        return accountPattern.matcher(account).matches();
    }
}
