/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import cn.com.duiba.wolf.utils.BlowfishUtils;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiqiOrderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiqiOrderUtil.class);
    private static final Pattern ORDER_ID_PATTERN = Pattern.compile("^[0-9]{19}[D][0-9]{8}$");
    private static final String TOKEN_KEY = "token";

    private BaiqiOrderUtil() {
    }

    public static String generateOrderToken(String orderId) {
        if (!BaiqiOrderUtil.matchOrderId(orderId)) {
            return null;
        }
        try {
            return BlowfishUtils.encryptBlowfish((String)orderId, (String)TOKEN_KEY);
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210orderToken\u51fa\u9519\uff0corderId={}", (Object)orderId, (Object)e);
            return null;
        }
    }

    public static String parsingOrderToken(String token) {
        String orderId;
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        try {
            orderId = BlowfishUtils.decryptBlowfish((String)token, (String)TOKEN_KEY);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790order token\u5f02\u5e38\uff0ctoken={}", (Object)token, (Object)e);
            return null;
        }
        if (!BaiqiOrderUtil.matchOrderId(orderId)) {
            LOGGER.warn("\u89e3\u6790order token\u9519\u8bef\uff0ctoken={}", (Object)token);
            return null;
        }
        return orderId;
    }

    public static boolean matchOrderId(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return ORDER_ID_PATTERN.matcher(value).matches();
    }
}

