/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.qiho.manager.common.exception.QihoManagerException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="ossFileService")
public class OSSFileService {
    private static final Logger log = LoggerFactory.getLogger(OSSFileService.class);
    @Autowired
    private OSSClient ossClient;
    @Value(value="${oss.bucketName}")
    private String bucketName;

    public String getOssFileContent(String url) {
        InputStream content = this.getOssFileInputStream(url);
        try {
            if (content == null) {
                String string = "";
                return string;
            }
            String string = IOUtils.toString((InputStream)content, (Charset)Charset.forName("UTF-8"));
            return string;
        }
        catch (IOException e) {
            throw new QihoManagerException("\u83b7\u53d6Oss\u6587\u4ef6\u5931\u8d25", e);
        }
        finally {
            this.closeInputStream(content);
        }
    }

    public InputStream getOssFileInputStream(String url) {
        String key = this.getOssKey(url);
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, key);
        return ossObject.getObjectContent();
    }

    public void closeInputStream(InputStream input) {
        IOUtils.closeQuietly((InputStream)input);
    }

    private String getOssKey(String url) {
        String urlWithProtocol = url;
        if (StringUtils.startsWith((CharSequence)url, (CharSequence)"//")) {
            urlWithProtocol = "http:" + url;
        }
        try {
            URL urlFix = new URL(urlWithProtocol);
            String key = urlFix.getPath();
            if (key.startsWith("/")) {
                key = key.substring(1, key.length());
            }
            return key;
        }
        catch (MalformedURLException e) {
            log.error("oss\u5730\u5740\u89e3\u6790\u51fa\u9519url={}", (Object)e, (Object)url);
            throw new QihoManagerException("oss\u5730\u5740\u89e3\u6790\u51fa\u9519", e);
        }
    }
}

