/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import com.google.common.collect.Lists;
import com.qiho.manager.common.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ReadExcelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadExcelUtil.class);
    private static boolean IS_EXCEL_2003 = true;
    private static boolean IS_EXCEL_2007 = false;

    private ReadExcelUtil() {
    }

    public static List<String> getExcelInfo(MultipartFile mFile) {
        String fileName = mFile.getOriginalFilename();
        try {
            if (!ReadExcelUtil.validateExcel(fileName)) {
                return Lists.newArrayList();
            }
            if (ReadExcelUtil.isExcel2007(fileName)) {
                IS_EXCEL_2003 = false;
                IS_EXCEL_2007 = true;
            }
            return ReadExcelUtil.createExcel(mFile.getInputStream(), IS_EXCEL_2003);
        }
        catch (Exception e) {
            LOGGER.info("\u8bfbEXCEL\u6587\u4ef6\uff0c\u83b7\u53d6\u4fe1\u606f\u96c6\u5408");
            return Lists.newArrayList();
        }
    }

    public static List<String> createExcel(InputStream is, boolean isExcel2003) {
        try {
            HSSFWorkbook wb;
            if (isExcel2003) {
                wb = new HSSFWorkbook(is);
            } else {
                IS_EXCEL_2003 = false;
                IS_EXCEL_2007 = true;
                wb = new XSSFWorkbook(is);
            }
            return ReadExcelUtil.readExcelValue((Workbook)wb);
        }
        catch (IOException e) {
            LOGGER.info("\u6839\u636eexcel\u91cc\u9762\u5185\u5bb9\u8bfb\u53d6\u4fe1\u606f\u5f02\u5e38");
            return Lists.newArrayList();
        }
    }

    private static List<String> readExcelValue(Workbook wb) {
        Sheet sheet = wb.getSheetAt(0);
        int totalRows = sheet.getPhysicalNumberOfRows();
        ArrayList<String> list = new ArrayList<String>();
        for (int r = 1; r <= totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null || ReadExcelUtil.hasNullCell(row)) continue;
            list.add(ReadExcelUtil.getRowStr(row, row.getPhysicalNumberOfCells()));
        }
        return list;
    }

    private static boolean hasNullCell(Row row) {
        Cell c;
        int num = 0;
        Iterator iterator = row.iterator();
        if (IS_EXCEL_2003) {
            while (iterator.hasNext()) {
                c = (Cell)iterator.next();
                if (c.getCellType() == 3) continue;
                ++num;
            }
        }
        if (IS_EXCEL_2007) {
            while (iterator.hasNext()) {
                c = (Cell)iterator.next();
                if (c.getCellType() == 3) continue;
                ++num;
            }
        }
        return num != row.getLastCellNum();
    }

    private static String getRowStr(Row row, int totalCells) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < totalCells; ++i) {
            String cellStr = ReadExcelUtil.convertToStr(row.getCell(i));
            stringBuilder.append(cellStr).append(",");
            if (i != totalCells - 1) continue;
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    private static String convertToStr(Cell cell) {
        HSSFDataFormatter dataFormatter;
        String cellStr = cell.toString();
        if (IS_EXCEL_2003) {
            switch (cell.getCellType()) {
                case 1: {
                    cellStr = cell.getStringCellValue();
                    break;
                }
                case 2: {
                    cellStr = cell.getCellFormula();
                    break;
                }
                case 0: {
                    dataFormatter = new HSSFDataFormatter();
                    cellStr = dataFormatter.formatCellValue(cell);
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
        if (IS_EXCEL_2007) {
            switch (cell.getCellType()) {
                case 1: {
                    cellStr = cell.getStringCellValue();
                    break;
                }
                case 2: {
                    cellStr = cell.getCellFormula();
                    break;
                }
                case 0: {
                    dataFormatter = new HSSFDataFormatter();
                    cellStr = dataFormatter.formatCellValue(cell);
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
        return cellStr;
    }

    private static boolean validateExcel(String filePath) {
        boolean validateResult;
        boolean bl = validateResult = StringUtil.isEmpty(filePath) || !ReadExcelUtil.isExcel2003(filePath) && !ReadExcelUtil.isExcel2007(filePath);
        if (validateResult) {
            LOGGER.info("\u6587\u4ef6\u540d\u4e0d\u662fexcel\u683c\u5f0f, filePath={}", (Object)filePath);
            return false;
        }
        return true;
    }

    public static boolean isExcel2003(String filePath) {
        return "^.+\\.(?i)(xls)$".matches(filePath);
    }

    public static boolean isExcel2007(String filePath) {
        return "^.+\\.(?i)(xlsx)$".matches(filePath);
    }
}

