/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import cn.com.duiba.wolf.utils.NumberUtils;
import com.google.common.collect.Lists;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final String SPLITTER = ",";

    private StringUtil() {
    }

    public static String subStr(String value, int maxSize) {
        if (null == value || "".equals(value) || value.length() <= maxSize) {
            return value;
        }
        return value.substring(0, maxSize) + "...";
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtil.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static boolean isNumeric(String value) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(value).matches();
    }

    public static boolean isNum(String value) {
        Pattern pattern = Pattern.compile("-?[0-9]+.*[0-9]*");
        return pattern.matcher(value).matches();
    }

    public static String idtourl(Long id) {
        if (id == null) {
            return "";
        }
        return 1 + Long.toString(id * 2L + 56L, 36);
    }

    public static long urltolongId(String url) {
        return (Long.parseLong(url.substring(1), 36) - 56L) / 2L;
    }

    public static int urltoid(String url) {
        return (Integer.parseInt(url.substring(1), 36) - 56) / 2;
    }

    public static String removeCdnPath(String imagePath) {
        if (null == imagePath || "" == imagePath) {
            return imagePath;
        }
        if (imagePath.contains("mogucdn")) {
            return imagePath.substring(imagePath.indexOf(".com") + 4);
        }
        return imagePath;
    }

    public static String replaceBlank(String str) {
        return StringUtil.replaceBlank(str, "\\s*|\t|\r|\n");
    }

    public static String replaceBlank(String str, String regex) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static String replaceBlankWithoutMid(String str, String regex) {
        String dest = "";
        if (str != null) {
            Pattern pattern = Pattern.compile("(^[" + regex + "])|([" + regex + "]+$)");
            dest = pattern.matcher(str).replaceAll("");
        }
        return dest;
    }

    public static Map<String, String> strToMap(String str) {
        String[] strs;
        if (str.isEmpty()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : strs = str.split(";")) {
            String[] sTmp = s.split(":");
            map.put(sTmp[0], sTmp[1]);
        }
        return map;
    }

    public static String mapToStr(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || key.isEmpty()) continue;
            if (value == null || value.isEmpty()) {
                value = "";
            }
            sb.append(key).append(":").append(value).append(";");
        }
        return sb.toString();
    }

    public static String appendStr(String separator, String str1, String str2) {
        if (StringUtil.isEmpty(str2)) {
            return str1;
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isEmpty(str1)) {
            sb.append(str2);
        } else {
            sb.append(str1).append(separator).append(str2);
        }
        return sb.toString();
    }

    public static List<Integer> explode(String delimiter, String string) {
        ArrayList ret = Lists.newArrayList();
        if (StringUtil.isEmpty(string)) {
            return ret;
        }
        String[] stringArray = string.split(delimiter);
        if (stringArray.length > 0) {
            for (String id : stringArray) {
                ret.add(Integer.parseInt(id));
            }
        }
        return ret;
    }

    public static Integer str2Int(String str) {
        Integer value = null;
        if (StringUtil.isEmpty(str)) {
            return value;
        }
        String newStr = str.replaceFirst("^0*", "");
        if (StringUtil.isNumeric(newStr)) {
            value = Integer.parseInt(newStr);
        }
        return value;
    }

    public static boolean contains(String value, String searchChars) {
        if (StringUtil.isEmpty(value) || StringUtil.isEmpty(searchChars)) {
            return false;
        }
        return value.contains(searchChars);
    }

    public static List<Long> stringToListOrderByIds(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return Collections.emptyList();
        }
        String[] idStr = ids.split(SPLITTER);
        int len = idStr.length;
        ArrayList<Long> list = new ArrayList<Long>(len);
        for (String id : idStr) {
            String idTrim = id.trim();
            if (NumberUtils.isNumeric((String)idTrim)) {
                Long idLong = Long.valueOf(idTrim);
                if (list.contains(idLong)) continue;
                list.add(idLong);
                continue;
            }
            throw new QihoManagerException("\u975e\u6cd5\u8f93\u5165,id\u5fc5\u987b\u662f\u6570\u5b57");
        }
        return list;
    }

    public static String removeFourChar(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        byte[] conbyte = content.getBytes();
        int j = 0;
        for (int i = 0; i < conbyte.length; ++i) {
            if (j == 0 && (conbyte[i] & 0xF8) == 240) {
                j = 4;
            }
            if (j <= 0) continue;
            conbyte[i] = 48;
            --j;
        }
        String newContent = new String(conbyte);
        return newContent.replaceAll("0000", "");
    }

    public static boolean isFullChinese(String str) {
        String reg = "[\\u4e00-\\u9fa5]+";
        return str.matches(reg);
    }

    public static String hideConsumerInfo(String consumer) {
        if (StringUtils.isNotBlank((CharSequence)consumer)) {
            String surname = consumer.substring(0, 1);
            int length = consumer.length();
            return StringUtils.rightPad((String)surname, (int)length, (String)"*");
        }
        return consumer;
    }

    public static String hideMobileInfo(String mobile) {
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            return mobile.substring(0, 3) + "********";
        }
        return mobile;
    }
}

