/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import com.aliyun.api.AliyunClient;
import com.aliyun.api.AliyunRequest;
import com.aliyun.api.cdn.cdn20141111.request.RefreshObjectCachesRequest;
import com.aliyun.api.cdn.cdn20141111.response.RefreshObjectCachesResponse;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.ObjectMetadata;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.AppLogUtil;
import com.taobao.api.ApiException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadTool {
    private static final Logger LOG = LoggerFactory.getLogger(UploadTool.class);
    private static OSSClient ossClient;
    private static AliyunClient cdnClient;
    private static String bucketName;
    private static String objectPath;

    public static boolean uploadOss(File file, String objectName) {
        return UploadTool.uploadOss(file, objectName, null, null);
    }

    public static boolean uploadOss(File file, String objectName, String contentType) {
        return UploadTool.uploadOss(file, objectName, contentType, null);
    }

    private static boolean uploadOss(File file, String objectName, String contentType, String targetBucketName) {
        boolean resultFlag = false;
        String curreyBucketName = bucketName;
        if (StringUtils.isNotBlank((String)targetBucketName)) {
            curreyBucketName = targetBucketName;
        }
        if (!ossClient.doesBucketExist(curreyBucketName)) {
            AppLogUtil.warn(LOG, "oss\u4e0a\u4f20\u5931\u8d25\uff0cbucket\u3010{}\u3011\u4e0d\u5b58\u5728", curreyBucketName);
            return resultFlag;
        }
        try (FileInputStream content = new FileInputStream(file);){
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(file.length());
            if (!StringUtils.isEmpty((String)contentType)) {
                meta.setContentType(contentType);
            }
            boolean flag = false;
            if (UploadTool.isFileExist(objectName, curreyBucketName)) {
                flag = true;
            }
            ossClient.putObject(curreyBucketName, objectName, (InputStream)content, meta);
            if (flag) {
                UploadTool.refreshObjectCaches(objectName);
            }
            resultFlag = true;
        }
        catch (ClientException | OSSException | IOException e) {
            LOG.error(e.getMessage(), e);
            resultFlag = false;
        }
        return resultFlag;
    }

    public static String uploadOssNotCDN(File file, String objectName, String contentType) {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(file.length());
            if (!StringUtils.isEmpty((String)contentType)) {
                meta.setContentType(contentType);
            }
            meta.setContentDisposition("Attachment;Filename=\"" + file.getName() + "\"");
            ossClient.putObject(bucketName, objectName, file, meta);
            return objectPath + objectName;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new QihoManagerException("\u4e0a\u4f20cdn\u5931\u8d25", e);
        }
    }

    public static boolean uploadOssCss(File file, String objectName) {
        return UploadTool.uploadOss(file, objectName, "text/css");
    }

    public static boolean uploadOssJs(File file, String objectName) {
        return UploadTool.uploadOss(file, objectName, "application/x-javascript");
    }

    public static boolean uploadOssHtml(File file, String objectName) {
        return UploadTool.uploadOss(file, objectName, "text/html");
    }

    public static boolean uploadOssImg(File file, String objectName) {
        return UploadTool.uploadOss(file, objectName, "image/jpeg");
    }

    public static boolean uploadOssMp4(File file, String objectName) {
        return UploadTool.uploadOss(file, objectName, "video/mpeg4");
    }

    public static boolean refreshObjectCaches(String path) {
        RefreshObjectCachesRequest request = new RefreshObjectCachesRequest();
        request.setObjectType(ObjectType.File.name());
        request.setObjectPath(objectPath + path);
        boolean resultFlag = false;
        try {
            RefreshObjectCachesResponse response = (RefreshObjectCachesResponse)cdnClient.execute((AliyunRequest)request);
            resultFlag = StringUtils.isEmpty((String)response.getErrorCode());
        }
        catch (ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            resultFlag = false;
        }
        return resultFlag;
    }

    private static boolean isFileExist(String objectName, String targetBucketName) {
        try {
            String curreyBucketName = bucketName;
            if (StringUtils.isNotBlank((String)targetBucketName)) {
                curreyBucketName = targetBucketName;
            }
            ossClient.getObjectMetadata(curreyBucketName, objectName);
            return true;
        }
        catch (ClientException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (OSSException e) {
            if (!"NoSuchKey".equals(e.getErrorCode())) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public static boolean isFileExist(String objectName) {
        return UploadTool.isFileExist(objectName, null);
    }

    public void deleteObject(String objectName) {
        try {
            ossClient.deleteObject(bucketName, objectName);
        }
        catch (ClientException | OSSException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public static String uploadAdminOssFile(File file, String objectName) {
        boolean resultOss = false;
        String fileType = objectName.substring(objectName.lastIndexOf(46) + 1, objectName.length());
        resultOss = fileType.equalsIgnoreCase("jpg") || fileType.equalsIgnoreCase("jpeg") || fileType.equalsIgnoreCase("png") || fileType.equalsIgnoreCase("gif") ? UploadTool.uploadOss(file, objectName, "image/jpeg", "duiba") : (fileType.equalsIgnoreCase("js") ? UploadTool.uploadOss(file, objectName, "application/x-javascript", "duiba") : (fileType.equalsIgnoreCase("css") ? UploadTool.uploadOss(file, objectName, "text/css", "duiba") : (fileType.equalsIgnoreCase("html") ? UploadTool.uploadOss(file, objectName, "text/html", "duiba") : UploadTool.uploadOss(file, objectName, null, "duiba"))));
        if (resultOss) {
            return "https://" + objectPath + "/" + objectName;
        }
        return null;
    }

    public static void setBucketName(String bucketName) {
        UploadTool.bucketName = bucketName;
    }

    public static void setObjectPath(String objectPath) {
        UploadTool.objectPath = objectPath;
    }

    public static void setOssClient(OSSClient ossClient) {
        UploadTool.ossClient = ossClient;
    }

    public static void setCdnClient(AliyunClient cdnClient) {
        UploadTool.cdnClient = cdnClient;
    }

    static enum ObjectType {
        File,
        Directory;

    }
}

