package com.qiho.manager.common.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName: ErpErrorCodeEnum <br/>
 * Function: ERP系统接口请求业务类型枚举. <br/>
 * date: 2017年6月6日 下午4:05:02 <br/>
 *
 * @author chencheng
 * @version
 */
public enum ErpMethodNameEnum {
    /** 订单发货物流信息推送接口 */
    LOGISTICSRETURN("0", "LogisticsReturn");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private ErpMethodNameEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static ErpMethodNameEnum getByCode(String code) {
        for (ErpMethodNameEnum enumVal : ErpMethodNameEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
