package com.qiho.manager.common.enums;

/**
 * @author Wangpf
 * @description 错误码和错误信息
 * @date 2019/9/17 11:31 AM
 */
public enum ErrorCode {

    /**
     * 请求成功
     */
    SUCCESS(200,"SUCCESS"),

    /**
     * 重复请求(数据已经存在，或者短时间内重复请求)
     */
    REPEAT(201,"REPEAT"),

    /**
     * 只允许存在一个
     */
    ONLY_ONE(301,"ONLY_ONE"),

    /**
     * 非法请求
     */
    BAD_REQUEST(400,"BAD_REQUEST"),

    NOT_ALLOWED(403,"NOT_ALLOWED"),

    UNKNOWN_ERROR(500,"UNKNOWN_ERROR"),

    // 业务上的错误码
    /** 部分媒体已绑定相同模版 */
    APP_ONLY_ONE(601,"部分媒体已绑定相同模版"),

    /** 该短信模版不支持媒体定制 */
    APP_NOT_ALLOWED(602,"该短信模版不支持媒体定制"),
    ;


    private final int code;

    private final String msg;

    ErrorCode(int code,String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
